/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.common.utils;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);
    public static final String OS = System.getProperty("os.name").toLowerCase();
    private static final SecureRandom random = new SecureRandom();

    private Utils() {
    }

    public static String generateKey() {
        return new BigInteger(130, random).toString(32);
    }

    public static InputStream openClassPathResource(String path) {
        return Utils.class.getResourceAsStream(path);
    }

    public static String escapeQuotes(String s) {
        String strippedSlashes = StringUtils.replaceEach((String)s, (String[])new String[]{"\\\\'", "\\\\\"", "\\'", "\\\""}, (String[])new String[]{"'", "\"", "'", "\""});
        return StringUtils.replaceEach((String)strippedSlashes, (String[])new String[]{"'", "\""}, (String[])new String[]{"\\'", "\\\""});
    }
}

