/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.sdk.processor.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mobi.designmyapp.common.api.model.Image;
import mobi.designmyapp.common.api.model.UploadRequest;
import mobi.designmyapp.common.api.utils.UtilsFactory;
import mobi.designmyapp.sdk.processor.UploadProcessor;

public class IconUploadProcessor
extends UploadProcessor {
    public static final String NAMESPACE = "icon";
    private List<String> validExtensions = new ArrayList<String>();

    public IconUploadProcessor() {
        super(NAMESPACE);
        this.validExtensions.add("png");
        this.validExtensions.add("jpg");
        this.validExtensions.add("jpeg");
    }

    public Object process(UploadRequest request, File destDir) throws IOException {
        String url = UtilsFactory.getResourceUtils().createUrl(request.getAppId(), NAMESPACE, "icon.png", request.getPortalName());
        UtilsFactory.getImageUtils().resizeImageToIcon(request.getObj(), new File(destDir, "icon.png"));
        return new Image("icon.png", request.getOriginalFilename(), url);
    }

    @Override
    public List<String> getValidExtensions() {
        return this.validExtensions;
    }
}

