/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.sdk.processor.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mobi.designmyapp.common.api.model.Image;
import mobi.designmyapp.common.api.model.UploadRequest;
import mobi.designmyapp.common.api.utils.UtilsFactory;
import mobi.designmyapp.sdk.processor.UploadProcessor;
import org.apache.commons.codec.digest.DigestUtils;

public class ImageUploadProcessor
extends UploadProcessor<Image> {
    public static final String NAMESPACE = "image";
    private List<String> validExtensions = new ArrayList<String>();

    public ImageUploadProcessor(String namespace) {
        super(namespace);
        this.validExtensions.add("png");
        this.validExtensions.add("jpg");
        this.validExtensions.add("jpeg");
    }

    public ImageUploadProcessor() {
        this(NAMESPACE);
    }

    @Override
    public Image process(UploadRequest request, File destDir) throws IOException {
        File tmpFile = new File(destDir, request.getOriginalFilename() + ".tmp");
        UtilsFactory.getFileManagementUtils().copyInputStreamToFile(request.getObj(), tmpFile);
        String destFileName = DigestUtils.shaHex((String)String.valueOf(new FileInputStream(tmpFile))) + UtilsFactory.getFileManagementUtils().getExtension(request.getOriginalFilename());
        File destFile = new File(destDir, destFileName);
        if (!destFile.exists()) {
            UtilsFactory.getFileManagementUtils().moveFile(tmpFile, destFile);
        }
        return Image.builder().fileName(destFileName).originalName(request.getOriginalFilename()).prepareUrl().appId(request.getAppId()).namespace(NAMESPACE).portal(request.getPortalName()).build();
    }

    @Override
    public List<String> getValidExtensions() {
        return this.validExtensions;
    }
}

