/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.sdk.processor.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mobi.designmyapp.common.api.model.UploadRequest;
import mobi.designmyapp.common.api.utils.UtilsFactory;
import mobi.designmyapp.sdk.processor.ArchiveProcessor;
import mobi.designmyapp.sdk.processor.UploadProcessor;

public class ZipUploadProcessor
extends UploadProcessor {
    public static final String NAMESPACE = "zip";
    private List<String> validExtensions = new ArrayList<String>();

    public ZipUploadProcessor() {
        super(NAMESPACE);
        this.validExtensions.add(NAMESPACE);
    }

    public Object process(UploadRequest request, File destDir) throws IOException {
        File tmpZipFile = new File(destDir, "tmp.zip");
        UtilsFactory.getFileManagementUtils().copyInputStreamToFile(request.getObj(), tmpZipFile);
        String zipHash = UtilsFactory.getFileManagementUtils().createHash(tmpZipFile);
        File zipFile = new File(destDir, zipHash + ".zip");
        if (!zipFile.exists()) {
            UtilsFactory.getFileManagementUtils().moveFile(tmpZipFile, zipFile);
        } else {
            tmpZipFile.delete();
        }
        ArrayList<String> unhandledFiles = new ArrayList<String>();
        ArchiveProcessor archiveProcessor = (ArchiveProcessor)request.getResources();
        UtilsFactory.getZipUtils().unzip(zipFile, archiveProcessor.getValidExtensions(), unhandledFiles);
        File zipDir = new File(destDir, zipHash);
        return archiveProcessor.process(request, zipDir, unhandledFiles);
    }

    @Override
    public List<String> getValidExtensions() {
        return this.validExtensions;
    }
}

