/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.sdk.processor.impl;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import mobi.designmyapp.common.engine.model.Image;
import mobi.designmyapp.common.engine.model.UploadRequest;
import mobi.designmyapp.common.util.UtilsFactory;
import mobi.designmyapp.sdk.processor.UploadProcessor;

public class IconUploadProcessor
implements UploadProcessor<Image> {
    private static final String NAMESPACE = "icon";
    private final String iconFileName;
    private final List<String> validExtensions = Arrays.asList("png", "jpg", "jpeg", "gif");

    public IconUploadProcessor() {
        this.iconFileName = "icon.png";
    }

    public IconUploadProcessor(String iconFileName) {
        this.iconFileName = iconFileName;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public Image process(UploadRequest request, File destDir) throws IOException {
        String url = UtilsFactory.getResourceUtils().createUrl(request.getAppId(), NAMESPACE, this.iconFileName, request.getPortalName());
        UtilsFactory.getImageUtils().resizeImageToIcon(request.getObj(), new File(destDir, this.iconFileName));
        return new Image(this.iconFileName, request.getOriginalFilename(), url);
    }

    @Override
    public List<String> getValidExtensions() {
        return this.validExtensions;
    }
}

