/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.sdk.model;

import java.util.Collections;
import java.util.List;
import mobi.designmyapp.common.engine.model.Template;
import mobi.designmyapp.sdk.builder.AndroidBuilder;
import mobi.designmyapp.sdk.builder.IosBuilder;
import mobi.designmyapp.sdk.builder.WebappBuilder;
import mobi.designmyapp.sdk.processor.ArchiveProcessor;
import mobi.designmyapp.sdk.processor.ContentProcessor;
import mobi.designmyapp.sdk.processor.PriceProcessor;
import mobi.designmyapp.sdk.processor.UploadProcessor;
import mobi.designmyapp.sdk.validator.ContentValidator;

public abstract class Generator<T extends Template> {
    private final Class<T> type;

    public Generator(Class<T> type) {
        this.type = type;
    }

    public Class<T> getTemplateClass() {
        return this.type;
    }

    public List<String> getStaticResources() {
        return Collections.emptyList();
    }

    public abstract String getTemplateTag();

    public ContentValidator getValidator() {
        return null;
    }

    public ContentProcessor getProcessor() {
        return null;
    }

    public PriceProcessor getPriceProcessor() {
        return null;
    }

    public List<UploadProcessor> getUploadProcessors() {
        return null;
    }

    public List<ArchiveProcessor> getArchiveProcessors() {
        return null;
    }

    public AndroidBuilder<T> getAndroidBuilder() {
        return null;
    }

    public IosBuilder<T> getIosBuilder() {
        return null;
    }

    public WebappBuilder<T> getWebappBuilder() {
        return null;
    }
}

