/*
 * Decompiled with CFR 0.152.
 */
package mobi.designmyapp.sdk.processor.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mobi.designmyapp.common.engine.model.Image;
import mobi.designmyapp.common.engine.model.UploadRequest;
import mobi.designmyapp.common.util.DigestUtils;
import mobi.designmyapp.common.util.IOUtils;
import mobi.designmyapp.common.util.UtilsFactory;
import mobi.designmyapp.sdk.processor.UploadProcessor;

public class ImageUploadProcessor
implements UploadProcessor<Image> {
    public static final String DEFAULT_NAMESPACE = "image";
    private List<String> validExtensions = new ArrayList<String>();
    private final IOUtils ioUtils;
    private final DigestUtils digestUtils;
    private final String namespace;

    public ImageUploadProcessor(String namespace) {
        this.validExtensions.add("png");
        this.validExtensions.add("jpg");
        this.validExtensions.add("jpeg");
        this.ioUtils = UtilsFactory.getIOUtils();
        this.digestUtils = UtilsFactory.getDigestUtils();
        this.namespace = namespace;
    }

    public ImageUploadProcessor() {
        this(DEFAULT_NAMESPACE);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Image process(UploadRequest request, File destDir) throws IOException {
        File tmpFile = new File(destDir, request.getOriginalFilename() + ".tmp");
        this.ioUtils.copyInputStreamToFile(request.getObj(), tmpFile);
        String destFileName = this.digestUtils.shaHex(String.valueOf(new FileInputStream(tmpFile))) + this.ioUtils.getExtension(request.getOriginalFilename());
        File destFile = new File(destDir, destFileName);
        if (!destFile.exists()) {
            this.ioUtils.moveFile(tmpFile, destFile);
        }
        return Image.builder().fileName(destFileName).originalName(request.getOriginalFilename()).prepareUrl().appId(request.getAppId()).namespace(this.namespace).portal(request.getPortalName()).build();
    }

    @Override
    public List<String> getValidExtensions() {
        return this.validExtensions;
    }
}

