/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.eventmanager.engine;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import mt.edu.um.cs.rv.eventmanager.engine.MonitorEventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.router.RecipientListRouter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.ReflectionUtils;

public class CustomRecipientListRouter
extends RecipientListRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomRecipientListRouter.class);
    private boolean useLookupMap = false;
    private ConcurrentLinkedQueue<RecipientListRouter.Recipient> recipientList = null;
    private Multimap eventToMessageChannelMap = ArrayListMultimap.create();
    private QueueChannel noInterestedMonitorsQueueChannel;

    public CustomRecipientListRouter(QueueChannel noInterestedMonitorsQueueChannel) {
        this.noInterestedMonitorsQueueChannel = noInterestedMonitorsQueueChannel;
        this.recipientList = this.fetchRecipientList();
    }

    public void addRecipient(MessageChannel channel, MonitorEventSelector selector) {
        LOGGER.debug("Adding new channel for the following events [{}]", selector.getMonitor() != null ? selector.getMonitor().requiredEvents() : "UNKNOWN");
        if (this.useLookupMap) {
            Set classes = selector.getMonitor().requiredEvents();
            for (Class c : classes) {
                this.eventToMessageChannelMap.put((Object)c, (Object)channel);
            }
        } else {
            this.recipientList.add(new RecipientListRouter.Recipient(channel, (MessageSelector)selector));
        }
    }

    protected Collection<MessageChannel> determineTargetChannels(Message<?> message) {
        Collection ret = null;
        if (this.useLookupMap) {
            Class<?> payloadClass = message.getPayload().getClass();
            ret = this.eventToMessageChannelMap.get(payloadClass);
        } else {
            ret = super.determineTargetChannels(message);
        }
        if (ret == null || ret.isEmpty()) {
            ret = ImmutableList.of((Object)this.noInterestedMonitorsQueueChannel);
        }
        return ret;
    }

    private ConcurrentLinkedQueue<RecipientListRouter.Recipient> fetchRecipientList() {
        Field recipientsFields = ReflectionUtils.findField(RecipientListRouter.class, (String)"recipients");
        recipientsFields.setAccessible(true);
        ConcurrentLinkedQueue field = (ConcurrentLinkedQueue)ReflectionUtils.getField((Field)recipientsFields, (Object)((Object)this));
        return field;
    }

    public boolean isUseLookupMap() {
        return this.useLookupMap;
    }

    public void setUseLookupMap(boolean useLookupMap) {
        this.useLookupMap = useLookupMap;
    }
}

