/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.eventmanager.monitors.registry;

import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import mt.edu.um.cs.rv.eventmanager.engine.CustomRecipientListRouter;
import mt.edu.um.cs.rv.eventmanager.engine.MonitorEventSelector;
import mt.edu.um.cs.rv.eventmanager.monitors.MonitorInvocationServiceActivator;
import mt.edu.um.cs.rv.monitors.Monitor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.integration.channel.AbstractPollableChannel;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.PollableChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public class MonitorRegistry {
    @Autowired
    protected CustomRecipientListRouter recipientListRouter;
    @Autowired
    protected ConfigurableApplicationContext configurableApplicationContext;
    @Autowired
    protected Executor executor;
    @Autowired
    private TaskScheduler taskScheduler;

    @PostConstruct
    public void init() {
    }

    public ServiceActivatingHandler registerNewMonitor(Monitor monitor) {
        String channelName = monitor + "-" + UUID.randomUUID().toString();
        AbstractPollableChannel pollableChannel = this.createChannel(channelName);
        MonitorEventSelector selector = new MonitorEventSelector(monitor);
        return this.registerNewMonitor(monitor, pollableChannel, selector);
    }

    private ServiceActivatingHandler registerNewMonitor(Monitor monitor, AbstractPollableChannel inputMessageChannel, MonitorEventSelector messageSelector) {
        MonitorInvocationServiceActivator monitorInvocationSupport = new MonitorInvocationServiceActivator(monitor, (ApplicationContext)this.configurableApplicationContext);
        ServiceActivatingHandler serviceActivatingHandler = new ServiceActivatingHandler((Object)monitorInvocationSupport, "invokeMonitor");
        PollingConsumer pollingConsumer = new PollingConsumer((PollableChannel)inputMessageChannel, (MessageHandler)serviceActivatingHandler);
        PeriodicTrigger trigger = new PeriodicTrigger(10L, TimeUnit.MILLISECONDS);
        pollingConsumer.setTrigger((Trigger)trigger);
        pollingConsumer.setMaxMessagesPerPoll(1L);
        pollingConsumer.setTaskExecutor(this.executor);
        pollingConsumer.setTaskScheduler(this.taskScheduler);
        pollingConsumer.setBeanFactory((BeanFactory)this.configurableApplicationContext.getBeanFactory());
        pollingConsumer.setReceiveTimeout(0L);
        pollingConsumer.start();
        this.recipientListRouter.addRecipient((MessageChannel)inputMessageChannel, messageSelector);
        String serviceActivatorName = monitor.getName() + "-" + inputMessageChannel.getComponentName() + UUID.randomUUID().toString();
        this.configurableApplicationContext.getBeanFactory().registerSingleton(serviceActivatorName, (Object)serviceActivatingHandler);
        return serviceActivatingHandler;
    }

    private AbstractPollableChannel createChannel(String inputChannelName) {
        QueueChannel queueChannel = new QueueChannel();
        queueChannel.setBeanName(inputChannelName);
        queueChannel.setBeanFactory((BeanFactory)this.configurableApplicationContext);
        this.configurableApplicationContext.getBeanFactory().registerSingleton(inputChannelName, (Object)queueChannel);
        return queueChannel;
    }

    public CustomRecipientListRouter getRecipientListRouter() {
        return this.recipientListRouter;
    }

    public void setRecipientListRouter(CustomRecipientListRouter recipientListRouter) {
        this.recipientListRouter = recipientListRouter;
    }

    public ConfigurableApplicationContext getConfigurableApplicationContext() {
        return this.configurableApplicationContext;
    }

    public void setConfigurableApplicationContext(ConfigurableApplicationContext configurableApplicationContext) {
        this.configurableApplicationContext = configurableApplicationContext;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }
}

