/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.monitors;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mt.edu.um.cs.rv.events.Event;
import mt.edu.um.cs.rv.monitors.Monitor;
import mt.edu.um.cs.rv.monitors.persistence.InMemoryMonitorPersistenceProvider;
import mt.edu.um.cs.rv.monitors.persistence.MonitorPersistenceProvider;
import mt.edu.um.cs.rv.monitors.results.MonitorResult;
import mt.edu.um.cs.rv.monitors.results.MonitorResultList;
import mt.edu.um.cs.rv.monitors.state.State;

public abstract class StatefulMonitor<S extends State>
implements Monitor {
    private Set<Class<? extends Event>> requiredEvents = new HashSet<Class<? extends Event>>();
    private Map<Class<? extends Event>, List<Class<? extends Monitor>>> interestedMonitorTypesForEvent = new HashMap<Class<? extends Event>, List<Class<? extends Monitor>>>();
    private MonitorPersistenceProvider monitorPersistenceProvider = null;

    public StatefulMonitor() {
        this.initialiseRequiredEvents();
        this.initialiseInterestedMonitorTypesForEvent();
    }

    protected abstract void initialiseRequiredEvents();

    protected void addRequiredEvent(Class<? extends Event> eventClass) {
        this.requiredEvents.add(eventClass);
    }

    protected void addInterestedMonitorTypesForEvent(Class<? extends Event> eventClass, List<Class<? extends Monitor>> monitorClasses) {
        this.interestedMonitorTypesForEvent.put(eventClass, monitorClasses);
    }

    protected abstract void initialiseInterestedMonitorTypesForEvent();

    public void setMonitorPersistenceProvider(MonitorPersistenceProvider monitorPersistenceProvider) {
        this.monitorPersistenceProvider = monitorPersistenceProvider;
    }

    protected MonitorPersistenceProvider getMonitorPersistenceProvider() {
        if (this.monitorPersistenceProvider == null) {
            this.monitorPersistenceProvider = InMemoryMonitorPersistenceProvider.getInstance();
        }
        return this.monitorPersistenceProvider;
    }

    protected abstract S initialiseNewState();

    protected S loadOrCreateState(Class<? extends Monitor> c, Event e, State parentState) {
        State<Object> state = this.getMonitorPersistenceProvider().load(c);
        if (state == null) {
            state = this.initialiseNewState();
        }
        state.setParentState(parentState);
        return (S)state;
    }

    protected void persistState(Class<? extends Monitor> c, Event e, S s) {
        this.getMonitorPersistenceProvider().save(c, (State)s);
    }

    private List<Class<? extends Monitor>> getInterestedMonitorTypes(Event e) {
        return this.interestedMonitorTypesForEvent.get(e.getClass());
    }

    public final MonitorResult handleEvent(Event e, State parentState) {
        if (e == null) {
            throw new RuntimeException("Unable to handle null event");
        }
        List<Class<Monitor>> interestedMonitorTypes = this.getInterestedMonitorTypes(e);
        MonitorResultList monitorResultList = new MonitorResultList();
        for (Class<Monitor> c : interestedMonitorTypes) {
            S state = this.loadOrCreateState(this.getClass(), e, parentState);
            Monitor monitor = null;
            try {
                Constructor<Monitor> cons = c.getConstructor(new Class[0]);
                monitor = cons.newInstance(new Object[0]);
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            if (monitor instanceof StatefulMonitor) {
                ((StatefulMonitor)monitor).setMonitorPersistenceProvider(this.getMonitorPersistenceProvider());
            }
            MonitorResult monitorResult = monitor.handleEvent(e, state);
            monitorResultList.addMonitorResult(monitorResult);
            this.persistState(this.getClass(), e, state);
        }
        return monitorResultList;
    }

    @Override
    public Set<Class<? extends Event>> requiredEvents() {
        return this.requiredEvents;
    }
}

