/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.monitors.persistence;

import java.util.HashMap;
import java.util.Map;
import mt.edu.um.cs.rv.monitors.Monitor;
import mt.edu.um.cs.rv.monitors.persistence.MonitorPersistenceProvider;
import mt.edu.um.cs.rv.monitors.state.State;

public class InMemoryMonitorPersistenceProvider
implements MonitorPersistenceProvider {
    private Map<Key, State> stateMap = new HashMap<Key, State>();
    private static InMemoryMonitorPersistenceProvider singletonInstance = null;

    private InMemoryMonitorPersistenceProvider() {
    }

    public static synchronized InMemoryMonitorPersistenceProvider getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new InMemoryMonitorPersistenceProvider();
        }
        return singletonInstance;
    }

    @Override
    public State load(Class<? extends Monitor> monitorClass) {
        return this.load(monitorClass, null);
    }

    @Override
    public State load(Class<? extends Monitor> monitorClass, Object eventCategory) {
        Key key = new Key(monitorClass, eventCategory);
        return this.stateMap.get(key);
    }

    @Override
    public void save(Class<? extends Monitor> monitorClass, State state) {
        this.save(monitorClass, null, state);
    }

    @Override
    public void save(Class<? extends Monitor> monitorClass, Object eventCategory, State state) {
        Key key = new Key(monitorClass, eventCategory);
        this.stateMap.put(key, state);
    }

    private static final class Key {
        private String monitorType;
        private Object eventCategory;

        public Key(Class<? extends Monitor> monitorClass, Object eventCategory) {
            this.monitorType = monitorClass.getTypeName();
            this.eventCategory = eventCategory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.monitorType.equals(key.monitorType)) {
                return false;
            }
            return this.eventCategory != null ? this.eventCategory.equals(key.eventCategory) : key.eventCategory == null;
        }

        public int hashCode() {
            int result = this.monitorType.hashCode();
            result = 31 * result + (this.eventCategory != null ? this.eventCategory.hashCode() : 0);
            return result;
        }
    }
}

