/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.monitors.results;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import mt.edu.um.cs.rv.monitors.results.MonitorResultStatus;

public class MonitorResult<P extends Serializable>
implements Serializable {
    private MonitorResultStatus status;
    private Optional<P> payload;
    private Optional<String> throwableClassName;
    private Optional<String> throwableMessage;
    private Optional<StackTraceElement[]> throwableStackTrace;

    protected MonitorResult(MonitorResultStatus status, P payload) {
        this(status, payload, null, null, null);
    }

    protected MonitorResult(MonitorResultStatus status, P payload, String throwableClassName, String throwableMessage, StackTraceElement[] throwableStackTrace) {
        this.status = status;
        this.payload = Optional.ofNullable(payload);
        this.throwableClassName = Optional.ofNullable(throwableClassName);
        this.throwableMessage = Optional.ofNullable(throwableMessage);
        this.throwableStackTrace = Optional.ofNullable(throwableStackTrace);
    }

    public static MonitorResult<?> ok() {
        return new MonitorResult<Object>(MonitorResultStatus.OK, null);
    }

    public static <P extends Serializable> MonitorResult<P> ok(P payload) {
        return new MonitorResult<P>(MonitorResultStatus.OK, payload);
    }

    public static MonitorResult<?> error() {
        return MonitorResult.error(null);
    }

    public static <P extends Serializable> MonitorResult<P> error(P payload) {
        return MonitorResult.error(payload, null);
    }

    public static <P extends Serializable> MonitorResult<P> error(P payload, Throwable throwable) {
        if (throwable == null) {
            throwable = new Throwable();
        }
        return new MonitorResult<P>(MonitorResultStatus.ERROR, payload, throwable.getClass().getName(), throwable.getMessage(), throwable.getStackTrace());
    }

    public static MonitorResult<?> failure() {
        return MonitorResult.failure(null);
    }

    public static <P extends Serializable> MonitorResult<P> failure(P payload) {
        return MonitorResult.failure(payload, null);
    }

    public static <P extends Serializable> MonitorResult<P> failure(P payload, Throwable throwable) {
        if (throwable == null) {
            throwable = new Throwable();
        }
        return new MonitorResult<P>(MonitorResultStatus.FAILURE, payload, throwable.getClass().getName(), throwable.getMessage(), throwable.getStackTrace());
    }

    public MonitorResultStatus getStatus() {
        return this.status;
    }

    protected void setStatus(MonitorResultStatus status) {
        this.status = status;
    }

    public Optional<P> getPayload() {
        return this.payload;
    }

    public Optional<String> getThrowableClassName() {
        return this.throwableClassName;
    }

    public Optional<String> getThrowableMessage() {
        return this.throwableMessage;
    }

    public Optional<StackTraceElement[]> getThrowableStackTrace() {
        return this.throwableStackTrace;
    }

    private String getThrowableStackTraceAsString() {
        if (!this.throwableStackTrace.isPresent()) {
            return "";
        }
        StackTraceElement[] stes = this.throwableStackTrace.orElse(new StackTraceElement[0]);
        return Arrays.stream(stes).skip(0L).map(StackTraceElement::toString).collect(Collectors.joining("\",\"", "\"", "\""));
    }

    protected String getPayloadAsString() {
        if (this.payload.isPresent()) {
            return "\"" + ((Serializable)this.payload.get()).toString() + "\"";
        }
        return null;
    }

    public String toString() {
        return "{\"status\": \"" + (Object)((Object)this.status) + "\",\"statusDescription\": \"" + this.status.getDescription() + "\",\"payload\": " + this.getPayloadAsString() + ",\"throwableClassName\": \"" + (String)this.throwableClassName.orElse(null) + "\",\"throwableMessage\": \"" + (String)this.throwableMessage.orElse(null) + "\",\"throwableStackTrace\": [" + this.getThrowableStackTraceAsString() + "]" + '}';
    }
}

