/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.monitors;

import java.util.HashSet;
import java.util.Set;
import mt.edu.um.cs.rv.events.Event;
import mt.edu.um.cs.rv.events.UserCreatedEvent;
import mt.edu.um.cs.rv.monitors.DelegatingUserLoginLogoutMonitor;
import mt.edu.um.cs.rv.monitors.Monitor;
import mt.edu.um.cs.rv.monitors.UserLoginLogoutMonitor;
import mt.edu.um.cs.rv.monitors.results.MonitorResult;
import mt.edu.um.cs.rv.monitors.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessagingException;

public class UserCreationMonitor
implements Monitor {
    private static Logger LOGGER = LoggerFactory.getLogger(UserCreationMonitor.class);
    private DelegatingUserLoginLogoutMonitor delegatingUserLoginLogoutMonitor;
    private Set<Class<? extends Event>> requiredEvents;

    public UserCreationMonitor(DelegatingUserLoginLogoutMonitor delegatingUserLoginLogoutMonitor) {
        this.delegatingUserLoginLogoutMonitor = delegatingUserLoginLogoutMonitor;
        this.requiredEvents = new HashSet<Class<? extends Event>>();
        this.requiredEvents.add(UserCreatedEvent.class);
    }

    public String getName() {
        return "UserCreationMonitor";
    }

    public Set<Class<? extends Event>> requiredEvents() {
        return this.requiredEvents;
    }

    public MonitorResult handleEvent(Event event, State s) throws MessagingException {
        LOGGER.info("Processing {}", (Object)event.getClass().getName());
        UserCreatedEvent userCreatedEvent = (UserCreatedEvent)event;
        UserLoginLogoutMonitor userLoginLogoutMonitor = new UserLoginLogoutMonitor(userCreatedEvent.getUsername());
        this.delegatingUserLoginLogoutMonitor.addUserLoginLogoutMonitor(userLoginLogoutMonitor);
        return MonitorResult.ok();
    }
}

