/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.monitors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import mt.edu.um.cs.rv.events.Event;
import mt.edu.um.cs.rv.events.LoginEvent;
import mt.edu.um.cs.rv.events.LogoutEvent;
import mt.edu.um.cs.rv.events.UserEvent;
import mt.edu.um.cs.rv.monitors.Monitor;
import mt.edu.um.cs.rv.monitors.UserLoginLogoutMonitor;
import mt.edu.um.cs.rv.monitors.results.MonitorResult;
import mt.edu.um.cs.rv.monitors.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingUserLoginLogoutMonitor
implements Monitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingUserLoginLogoutMonitor.class);
    private ConcurrentLinkedQueue<UserLoginLogoutMonitor> monitors;
    private Set<Class<? extends Event>> requiredEvents;

    public DelegatingUserLoginLogoutMonitor(List<UserLoginLogoutMonitor> monitors) {
        this.monitors = new ConcurrentLinkedQueue<UserLoginLogoutMonitor>(monitors);
        this.requiredEvents = new HashSet<Class<? extends Event>>();
        this.requiredEvents.add(LoginEvent.class);
        this.requiredEvents.add(LogoutEvent.class);
    }

    public String getName() {
        return "For Each User - Parent";
    }

    public Set<Class<? extends Event>> requiredEvents() {
        return this.requiredEvents;
    }

    public boolean addUserLoginLogoutMonitor(UserLoginLogoutMonitor monitor) {
        return this.monitors.add(monitor);
    }

    public MonitorResult handleEvent(Event event, State s) {
        UserEvent userEvent = (UserEvent)event;
        LOGGER.info("[{}] delegating {} for user {}", new Object[]{this.getName(), event.getClass().getName(), userEvent.getUsername()});
        int handleCount = 0;
        for (UserLoginLogoutMonitor monitor : this.monitors) {
            if (!monitor.getUsername().equals(userEvent.getUsername())) continue;
            monitor.handleEvent(event, s);
            ++handleCount;
        }
        LOGGER.info("[{}] delegated {} for user {} to {} UserLoginLogoutMonitor(s)", new Object[]{this.getName(), event.getClass().getName(), userEvent.getUsername(), handleCount});
        return MonitorResult.ok();
    }
}

