/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.monitors;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import mt.edu.um.cs.rv.events.Event;
import mt.edu.um.cs.rv.events.LoginEvent;
import mt.edu.um.cs.rv.events.LogoutEvent;
import mt.edu.um.cs.rv.monitors.Monitor;
import mt.edu.um.cs.rv.monitors.results.MonitorResult;
import mt.edu.um.cs.rv.monitors.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessagingException;

public class UserLoginLogoutMonitor
implements Monitor {
    private static Logger LOGGER = LoggerFactory.getLogger(UserLoginLogoutMonitor.class);
    private String username;
    private Set<Class<? extends Event>> requiredEvents;
    private AtomicLong loginCount = new AtomicLong();
    private AtomicLong logoutCount = new AtomicLong();

    public UserLoginLogoutMonitor(String username) {
        this.username = username;
        this.requiredEvents = new HashSet<Class<? extends Event>>();
        this.requiredEvents.add(LoginEvent.class);
        this.requiredEvents.add(LogoutEvent.class);
    }

    public String getName() {
        return "UserLoginLogoutMonitor for " + this.username;
    }

    public String getUsername() {
        return this.username;
    }

    public Set<Class<? extends Event>> requiredEvents() {
        return this.requiredEvents;
    }

    public MonitorResult handleEvent(Event event, State s) throws MessagingException {
        if (LoginEvent.class.equals(event.getClass())) {
            long l = this.loginCount.incrementAndGet();
            LOGGER.info("[{}] processing {} for user {}. Total logins observed for user {}: {}", new Object[]{this.getName(), event.getClass().getName(), this.username, this.username, l});
        } else if (LogoutEvent.class.equals(event.getClass())) {
            long l = this.logoutCount.incrementAndGet();
            LOGGER.info("[{}] processing {} for user {}. Total logouts observed for user {}: {}", new Object[]{this.getName(), event.getClass().getName(), this.username, this.username, l});
        } else {
            throw new IllegalStateException();
        }
        return MonitorResult.ok();
    }
}

