/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.sample.controller;

import mt.edu.um.cs.rv.eventmanager.monitors.registry.MonitorRegistry;
import mt.edu.um.cs.rv.eventmanager.observers.DirectInvocationEventObserver;
import mt.edu.um.cs.rv.events.Event;
import mt.edu.um.cs.rv.events.LoginEvent;
import mt.edu.um.cs.rv.events.LogoutEvent;
import mt.edu.um.cs.rv.events.UserCreatedEvent;
import mt.edu.um.cs.rv.monitors.GlobalUserLogoutCounterMonitor;
import mt.edu.um.cs.rv.monitors.Monitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HelloWorldController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelloWorldController.class);
    @Autowired
    DirectInvocationEventObserver directInvocationEventAdaptor;
    @Autowired
    MonitorRegistry monitorRegistry;
    private Boolean synchronous = Boolean.TRUE;

    @RequestMapping(value={"/login/{username:.+}"})
    public String login(@PathVariable String username) {
        LOGGER.info("================================================================================================");
        LOGGER.info("Handling request for User {} log in", (Object)username);
        this.directInvocationEventAdaptor.observeEvent((Event)new LoginEvent(username, this.synchronous));
        LOGGER.info("Handled request for User {} log in", (Object)username);
        LOGGER.info("================================================================================================");
        return "OK";
    }

    @RequestMapping(value={"/logout/{username:.+}"})
    public String logout(@PathVariable String username) {
        LOGGER.info("================================================================================================");
        LOGGER.info("Handling request for User {} log out", (Object)username);
        this.directInvocationEventAdaptor.observeEvent((Event)new LogoutEvent(username, this.synchronous));
        LOGGER.info("Handled request for User {} log out", (Object)username);
        LOGGER.info("================================================================================================");
        return "OK";
    }

    @RequestMapping(value={"/create/{username:.+}"})
    public String newUser(@PathVariable String username) {
        LOGGER.info("================================================================================================");
        LOGGER.info("Handling request for User {} creation", (Object)username);
        this.directInvocationEventAdaptor.observeEvent((Event)new UserCreatedEvent(username, this.synchronous));
        LOGGER.info("Handled request for User {} creation", (Object)username);
        LOGGER.info("================================================================================================");
        return "OK";
    }

    @RequestMapping(value={"/system/sync"})
    public Boolean synchronous() {
        return this.synchronous;
    }

    @RequestMapping(value={"/system/sync"}, method={RequestMethod.POST})
    public Boolean setSystemToSynchronous() {
        this.synchronous = Boolean.TRUE;
        return this.synchronous;
    }

    @RequestMapping(value={"/system/async"}, method={RequestMethod.POST})
    public Boolean setSystemToASynchronous() {
        this.synchronous = Boolean.FALSE;
        return this.synchronous;
    }

    @RequestMapping(value={"/system/logoutMonitor"}, method={RequestMethod.POST})
    public Boolean registerGlobalUserLogoutCounterMonitor() {
        GlobalUserLogoutCounterMonitor globalUserLogoutCounterMonitor = new GlobalUserLogoutCounterMonitor();
        this.monitorRegistry.registerNewMonitor((Monitor)globalUserLogoutCounterMonitor);
        return Boolean.TRUE;
    }
}

