/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.tests;

import com.google.inject.Inject;
import mt.edu.um.cs.rv.tests.ValourInjectorProvider;
import mt.edu.um.cs.rv.valour.Model;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipse.xtext.junit4.XtextRunner;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xtype.XImportSection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=ValourInjectorProvider.class)
public class ValourParsingTest {
    @Inject
    private ParseHelper<Model> parseHelper;

    @Test
    public void loadEmptyModel() {
        try {
            StringConcatenation _builder = new StringConcatenation();
            Model model = (Model)this.parseHelper.parse((CharSequence)_builder);
            Assert.assertNotNull((Object)model);
            XImportSection _imports = model.getImports();
            Assert.assertNull((Object)_imports);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Test
    public void loadModelWithImportsOnly() {
        try {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"import java.lang.String");
            _builder.newLine();
            _builder.append((Object)"import java.util.UUID");
            _builder.newLine();
            Model model = (Model)this.parseHelper.parse((CharSequence)_builder);
            Assert.assertNotNull((Object)model);
            XImportSection _imports = model.getImports();
            EList _importDeclarations = _imports.getImportDeclarations();
            int _length = ((Object[])Conversions.unwrapArray((Object)_importDeclarations, Object.class)).length;
            Assert.assertEquals((long)2L, (long)_length);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

