/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.monitors;

import mt.edu.um.cs.rv.events.CategorisedEvent;
import mt.edu.um.cs.rv.events.Event;
import mt.edu.um.cs.rv.monitors.Monitor;
import mt.edu.um.cs.rv.monitors.StatefulMonitor;
import mt.edu.um.cs.rv.monitors.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CategorisedStatefulMonitor<S extends State>
extends StatefulMonitor<S> {
    private static Logger LOGGER = LoggerFactory.getLogger(CategorisedStatefulMonitor.class);

    @Override
    protected S loadOrCreateState(Class<? extends Monitor> c, Event e, State parentState) {
        CategorisedEvent ce = null;
        if (e instanceof CategorisedEvent) {
            ce = (CategorisedEvent)e;
        } else {
            LOGGER.error("Unable to load state for monitor {}, as supplied event [{}] is not an instance of CategorisedEvent", (Object)c.getName(), (Object)e);
        }
        State<Object> state = this.getMonitorPersistenceProvider().load(c, ce.categoriseEvent());
        if (state == null) {
            state = this.initialiseNewState();
        }
        state.setParentState(parentState);
        return (S)state;
    }

    @Override
    protected void persistState(Class<? extends Monitor> c, Event e, S s) {
        CategorisedEvent ce = null;
        if (e instanceof CategorisedEvent) {
            ce = (CategorisedEvent)e;
        } else {
            LOGGER.error("Unable to save state for monitor {}, as supplied event [{}] is not an instance of CategorisedEvent", (Object)c.getName(), (Object)e);
        }
        this.getMonitorPersistenceProvider().save(c, ce.categoriseEvent(), (State)s);
    }
}

