/*
 * generated by Xtext 2.9.2
 */
package mt.edu.um.cs.rv.scoping

import javax.inject.Inject
import mt.edu.um.cs.rv.utils.ValourScriptTraverser
import mt.edu.um.cs.rv.valour.Action
import mt.edu.um.cs.rv.valour.ActionRef
import mt.edu.um.cs.rv.valour.Category
import mt.edu.um.cs.rv.valour.CategoryRef
import mt.edu.um.cs.rv.valour.Condition
import mt.edu.um.cs.rv.valour.ConditionRef
import mt.edu.um.cs.rv.valour.Event
import mt.edu.um.cs.rv.valour.EventRef
import mt.edu.um.cs.rv.valour.MonitorTriggerFire
import mt.edu.um.cs.rv.valour.SimpleTrigger
import mt.edu.um.cs.rv.valour.WhereClause
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.xtext.EcoreUtil2
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.Scopes

/**
 * This class contains custom scoping description.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#scoping
 * on how and when to use it.
 */
class ValourScopeProvider extends AbstractValourScopeProvider {

	@Inject extension ValourScriptTraverser

	override getScope(EObject context, EReference reference) {
		var IScope iScope = super.getScope(context, reference)

		if (context instanceof EventRef) {
			return buildScopeForReference(context, Event)
		} else if (context instanceof ActionRef) {
			return buildScopeForReference(context, Action)
		} else if (context instanceof CategoryRef) {
			return buildScopeForReference(context, Category)
		} else if (context instanceof ConditionRef) {
			return buildScopeForReference(context, Condition)
		} else if (context instanceof MonitorTriggerFire) {
			return buildScopeForMonitorTriggerFire(context)
		} else if (context instanceof WhereClause) {
			return buildScopeForWhereClause(context)
		} else {
			return iScope
		}

	}

	def <R extends EObject, X extends EObject> buildScopeForReference(X context, Class<R> referencedType) {
		val declarationsList = newArrayList()

		var declarations = findClosestDeclaration(context)

		if (declarations != null) {
			do {
				declarationsList.add(declarations)
				declarations = findClosestDeclaration(declarations.eContainer.eContainer)
			} while (declarations != null)

			// build the scope object
			var IScope parent = IScope.NULLSCOPE
			for (var i = declarationsList.size - 1; i >= 0; i--) {

				declarations = declarationsList.get(i)

				val candidates = EcoreUtil2.getAllContentsOfType(declarations, referencedType)
				parent = Scopes.scopeFor(candidates, parent)
			}

			return parent
		}
	}

	def <R extends EObject, X extends EObject> buildScopeForMonitorTriggerFire(X context) {
		val declarationsList = newArrayList()

		var declarations = findClosestDeclaration(context)

		if (declarations != null) {
			do {
				declarationsList.add(declarations)
				declarations = findClosestDeclaration(declarations.eContainer.eContainer)
			} while (declarations != null)

			// build the scope object
			var IScope parent = IScope.NULLSCOPE
			for (var i = declarationsList.size - 1; i >= 0; i--) {

				declarations = declarationsList.get(i)

				// get all events with monitor triggers
				val candidates = EcoreUtil2.getAllContentsOfType(declarations, Event)
					.map[e | filterMonitorTriggers(e)]
					.flatten 

				parent = Scopes.scopeFor(candidates, parent)
			}

			return parent
		}
	}	

	def filterMonitorTriggers(Event e) {
		val eventBody = e.eventBody
		
		val monitorTriggerList = newArrayList()
		
		if (isMonitorTrigger(eventBody.trigger)) {
			monitorTriggerList.add(eventBody.trigger.monitorTrigger)
		}
		 
		var additionalTrigger = eventBody.additionalTrigger
		
		while (additionalTrigger != null){
			if (isMonitorTrigger(additionalTrigger.trigger)){
				monitorTriggerList.add(additionalTrigger.trigger.monitorTrigger)
			}	
			additionalTrigger = additionalTrigger.additionalTrigger
		}
		
		return monitorTriggerList
	}
	
	def boolean isMonitorTrigger(SimpleTrigger st){
		st.monitorTrigger != null
	}
	
	
	def <R extends EObject, X extends EObject> buildScopeForWhereClause(WhereClause whereClause) {
		val event = findFirstAncestorOfType(whereClause, Event)
		
		var IScope scope = IScope.NULLSCOPE
		
		if (event != null){
			val parameters = event.eventFormalParameters.parameters
			scope = Scopes.scopeFor(parameters, scope)
		}
		
		return scope
	}
}
