/*
 * generated by Xtext 2.9.2
 */
package mt.edu.um.cs.rv.validation

import javax.inject.Inject
import mt.edu.um.cs.rv.utils.ValourScriptTraverser
import mt.edu.um.cs.rv.valour.Event
import mt.edu.um.cs.rv.valour.EventRef
import mt.edu.um.cs.rv.valour.ExternalTrigger
import mt.edu.um.cs.rv.valour.ForEach
import mt.edu.um.cs.rv.valour.Rule
import mt.edu.um.cs.rv.valour.ValourPackage
import org.eclipse.xtext.common.types.JvmDeclaredType
import org.eclipse.xtext.validation.Check

/**
 * This class contains custom validation rules. 
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
class ValourValidator extends AbstractValourValidator {

	@Inject extension ValourScriptTraverser
	
	@Check
	def checkEventRefParameterCount(EventRef eventRef) {

		val e = eventRef.eCrossReferences.get(0) as Event

		var actualParameterCount = 0
		if (eventRef.eventActualParameters != null && !eventRef.eventActualParameters.parameters.isNullOrEmpty) {
			actualParameterCount = eventRef.eventActualParameters.parameters.size
		}

		var formalParameterCount = 0
		if (e.eventFormalParameters != null && !e.eventFormalParameters.parameters.isNullOrEmpty) {
			formalParameterCount = e.eventFormalParameters.parameters.size
		}

		if (actualParameterCount !=
			formalParameterCount) {
			var msg = '''Bad parameter count for event «e.name»: Expected «formalParameterCount» but found «actualParameterCount»'''
			error(msg, ValourPackage.Literals.EVENT_REF__EVENT_REF_ID);
		}

	}

	@Check
	def checkEventDeclarationUniqueness(Event event) {
		var declarations = findClosestDeclaration(event);
		
		if (declarations != null) {
			do {
				var events = declarations.declarations.filter[d | d.event != null].map[d | d.event]

				//remove this event
				events = events.filter[e | !e.equals(event)]
				
				var errors = events.filter[e | e.name.equals(event.name)]
				
				if (!errors.isNullOrEmpty){
					val msg = '''Duplicate event with name «event.name»'''
					error(msg, ValourPackage.Literals.EVENT__NAME)
					errors.forEach[e | error(msg, e, ValourPackage.Literals.EVENT__NAME)]
				}
				
				declarations = findClosestDeclaration(declarations.eContainer.eContainer)
			} while (declarations != null)
		}
	}
	
	@Check
	def checkForEachBlocksOnlyUseEventsWithTheRightCategorisation(ForEach forEach){
		val forEachCategory = forEach.category.category
		
		val rules = forEach.valourBody.rules.rules
		
		for (Rule r: rules){
			val basicRule = r.basicRule
			if (basicRule != null){
				val event = basicRule.event
				
				val eventCategorisation = event.eventRefId.eventBody.categorisation
				
				if ((eventCategorisation == null) || (eventCategorisation.category == null)){
					val msg = '''Event «event.eventRefId» cannot be used within a for-each constructor without declaring which category it belongs to'''
					error(msg, ValourPackage.Literals.FOR_EACH__VALOUR_BODY)		
				}
				else if (eventCategorisation.category.category != forEachCategory){
					val msg = '''Event «event.eventRefId.name» declares a different type of category [«eventCategorisation.category.category.name»], while the current for-each constructor expects category of [«forEachCategory.name»]'''
					error(msg, r, ValourPackage.Literals.RULE__BASIC_RULE)
				}
			}
		}
	}
	
	@Check
	def externalTriggerShouldExtendTrigger(ExternalTrigger externalTrigger){
		val triggerClassRef = externalTrigger.triggerClass
		if (triggerClassRef.type instanceof JvmDeclaredType){
			val JvmDeclaredType declaredType = triggerClassRef.type as JvmDeclaredType
			val valid = declaredType.superTypes.map[st | st.type.qualifiedName].contains("mt.edu.um.cs.rv.eventmanager.observers.ExternalEventObserver")
       		
       		if (!valid){
       			val msg = '''External Event Trigger should have a class that extends from mt.edu.um.cs.rv.eventmanager.observers.ExternalEventObserver as an event trigger class'''
				error(msg, ValourPackage.Literals.EXTERNAL_TRIGGER__TRIGGER_CLASS)
       		}
		}
	}
	
	@Check
	def externalTriggerDataShouldExtendTriggerData(ExternalTrigger externalTrigger){
		val dataClassRef = externalTrigger.dataClass
		if (dataClassRef.type instanceof JvmDeclaredType){
			val JvmDeclaredType declaredType = dataClassRef.type as JvmDeclaredType
       		val valid = declaredType.superTypes.map[st | st.type.qualifiedName].contains("mt.edu.um.cs.rv.events.triggers.TriggerData")
       		
       		if (!valid){
       			val msg = '''External Event Trigger Data should have a class that extends from mt.edu.um.cs.rv.events.triggers.TriggerData as an event trigger data class'''
				error(msg, ValourPackage.Literals.EXTERNAL_TRIGGER__DATA_CLASS)
       		}
		}
	}
}
