/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.eventmanager.engine;

import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import mt.edu.um.cs.rv.events.Event;
import mt.edu.um.cs.rv.monitors.results.MonitorResult;
import mt.edu.um.cs.rv.monitors.results.MonitorResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.core.AsyncMessagingTemplate;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;

public class EventMessageSender {
    private static Logger LOGGER = LoggerFactory.getLogger(EventMessageSender.class);
    private AsyncMessagingTemplate asyncMessagingTemplate;

    public EventMessageSender(AsyncMessagingTemplate asyncMessagingTemplate) {
        this.asyncMessagingTemplate = asyncMessagingTemplate;
    }

    private Future<MonitorResult<?>> sendAsync(final Event e) {
        LOGGER.debug("Building event system message from event {}", (Object)e.getClass().getName());
        Message eventMessage = MessageBuilder.withPayload((Object)e).setReplyChannelName("eventManagerResponseChannel").setErrorChannelName("eventManagerResponseChannel").build();
        LOGGER.debug("Sending event {} to event system message asynchronously (if event is sync, we will block to wait for response)", (Object)e.getClass().getName());
        final Future messageFuture = this.asyncMessagingTemplate.asyncSendAndReceive("eventManagerRequestChannel", eventMessage);
        Future monitorResultFuture = new Future<MonitorResult<?>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return messageFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return messageFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return messageFuture.isDone();
            }

            @Override
            public MonitorResult get() throws InterruptedException, ExecutionException {
                Message message = (Message)messageFuture.get();
                return this.transformResult(message);
            }

            @Override
            public MonitorResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                Message message = (Message)messageFuture.get(timeout, unit);
                return this.transformResult(message);
            }

            private MonitorResult<?> transformResult(Message<?> r) {
                LOGGER.debug("Preparing response for event {}", (Object)e.getClass().getName());
                Object payload = r.getPayload();
                if (payload == null) {
                    LOGGER.debug("Received a null MonitorResult for event {} processing, creating and returning a OK MonitorResult", (Object)e.getClass().getName());
                    return MonitorResult.ok();
                }
                if (payload instanceof MonitorResult) {
                    LOGGER.debug("Received MonitorResult [{}] as response for event {} processing, returning the results", payload, (Object)e.getClass().getName());
                    return (MonitorResult)payload;
                }
                if (payload instanceof Collection) {
                    LOGGER.debug("Received a collection of MonitorResult [{}] as response for event {} processing, returning the results as a MonitorResultList", payload, (Object)e.getClass().getName());
                    Collection payloadColl = (Collection)payload;
                    MonitorResultList monitorResultList = new MonitorResultList();
                    payloadColl.stream().forEach(o -> monitorResultList.addMonitorResult((MonitorResult)o));
                    return monitorResultList;
                }
                if (payload instanceof Throwable) {
                    Throwable throwable = (Throwable)payload;
                    String msg = String.format("Received an unexpected response type of Throwable - [%s]", payload.getClass());
                    LOGGER.error("{} for event {} processing. Creating and returning a FAILURE MonitorResult.", new Object[]{msg, e.getClass().getName(), throwable});
                    MonitorResult<Object> failure = MonitorResult.failure(null, throwable);
                    LOGGER.error("Created FAILURE MonitorResult [{}]", failure);
                    return failure;
                }
                String msg = String.format("Received an unexpected response type of [%s]", payload.getClass());
                Throwable throwable = new RuntimeException(msg);
                Object serializable = msg;
                if (payload instanceof Throwable) {
                    throwable = (Throwable)payload;
                } else if (payload instanceof Serializable) {
                    serializable = (Serializable)payload;
                }
                LOGGER.error("{} for event {} processing. Creating and returning a FAILURE MonitorResult.", new Object[]{msg, e.getClass().getName(), throwable});
                MonitorResult<Object> failure = MonitorResult.failure(serializable, throwable);
                LOGGER.error("Created FAILURE MonitorResult [{}]", failure);
                return failure;
            }
        };
        return monitorResultFuture;
    }

    public Future<MonitorResult<?>> send(Event e) {
        try {
            Future<MonitorResult<?>> monitorResultFuture = this.sendAsync(e);
            if (e.isSynchronous()) {
                LOGGER.debug("Event {} is synchronous, blocking to wait for response", (Object)e.getClass().getName());
                monitorResultFuture.get();
            }
            return monitorResultFuture;
        }
        catch (MessagingException me) {
            String msg = "Unexpected MessageException occurred";
            LOGGER.error("{} for event {} processing. Creating and returning a FAILURE MonitorResult.", new Object[]{msg, e.getClass().getName(), me});
            MonitorResult<Object> failureResult = MonitorResult.failure(null, me);
            return CompletableFuture.completedFuture(failureResult);
        }
        catch (Throwable t) {
            String msg = "Unexpected Throwable occurred";
            LOGGER.error("{} for event {} processing. Creating and returning a FAILURE MonitorResult.", new Object[]{e.getClass().getName(), msg, t});
            MonitorResult<Object> failureResult = MonitorResult.failure(null, t);
            return CompletableFuture.completedFuture(failureResult);
        }
    }
}

