/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.eventmanager.engine.config;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import mt.edu.um.cs.rv.eventmanager.adaptors.EventAdaptorConfiguration;
import mt.edu.um.cs.rv.eventmanager.engine.AfterAllMessagesInGroupReleaseStrategy;
import mt.edu.um.cs.rv.eventmanager.engine.CustomRecipientListRouter;
import mt.edu.um.cs.rv.eventmanager.engine.EventMessageSender;
import mt.edu.um.cs.rv.eventmanager.monitors.registry.MonitorRegistry;
import mt.edu.um.cs.rv.eventmanager.monitors.registry.NoInterestedMonitorsHandler;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.integration.aggregator.AggregatingMessageHandler;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.DefaultAggregatingMessageGroupProcessor;
import org.springframework.integration.aggregator.HeaderAttributeCorrelationStrategy;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.integration.core.AsyncMessagingTemplate;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.integration.scattergather.ScatterGatherHandler;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.SimpleMessageStore;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.PollableChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

@Configuration
@EnableIntegration
@Import(value={EventAdaptorConfiguration.class})
public class EventManagerConfigration {
    public static final String EVENT_MANAGER_REQUEST_CHANNEL = "eventManagerRequestChannel";
    public static final String EVENT_MANAGER_RESPONSE_CHANNEL = "eventManagerResponseChannel";

    @Bean
    @ServiceActivator(inputChannel="eventManagerRequestChannel")
    public MessageHandler scatterGatherDistribution() {
        ScatterGatherHandler handler = new ScatterGatherHandler(this.distributor(), this.gatherer());
        return handler;
    }

    @Bean
    public MessageHandler distributor() {
        return this.recipientListRouter();
    }

    public CustomRecipientListRouter recipientListRouter() {
        CustomRecipientListRouter router = new CustomRecipientListRouter(this.noInterestedMonitorsQueueChannel());
        router.setApplySequence(true);
        return router;
    }

    @Bean
    public AsyncMessagingTemplate inputMessagingTemplate() {
        return new AsyncMessagingTemplate();
    }

    @Bean
    public EventMessageSender eventMessageSender() {
        return new EventMessageSender(this.inputMessagingTemplate());
    }

    @Bean
    public MessageHandler gatherer() {
        return new AggregatingMessageHandler((MessageGroupProcessor)new DefaultAggregatingMessageGroupProcessor(), (MessageGroupStore)new SimpleMessageStore(), (CorrelationStrategy)new HeaderAttributeCorrelationStrategy("correlationId"), (ReleaseStrategy)new AfterAllMessagesInGroupReleaseStrategy());
    }

    @Bean
    public MonitorRegistry monitorRegistry() {
        return new MonitorRegistry();
    }

    @Bean
    public QueueChannel noInterestedMonitorsQueueChannel() {
        return new QueueChannel();
    }

    @Bean
    public ServiceActivatingHandler noInterestedMonitorsServiceActivatingHandler(Executor executor, TaskScheduler taskScheduler, ConfigurableApplicationContext configurableApplicationContext) {
        NoInterestedMonitorsHandler noInterestedMonitorsHandler = new NoInterestedMonitorsHandler();
        ServiceActivatingHandler serviceActivatingHandler = new ServiceActivatingHandler((Object)noInterestedMonitorsHandler, "handleEvent");
        PollingConsumer pollingConsumer = new PollingConsumer((PollableChannel)this.noInterestedMonitorsQueueChannel(), (MessageHandler)serviceActivatingHandler);
        PeriodicTrigger trigger = new PeriodicTrigger(10L, TimeUnit.MILLISECONDS);
        pollingConsumer.setTrigger((Trigger)trigger);
        pollingConsumer.setMaxMessagesPerPoll(1L);
        pollingConsumer.setTaskExecutor(executor);
        pollingConsumer.setTaskScheduler(taskScheduler);
        pollingConsumer.setBeanFactory((BeanFactory)configurableApplicationContext.getBeanFactory());
        pollingConsumer.setReceiveTimeout(0L);
        pollingConsumer.start();
        return serviceActivatingHandler;
    }
}

