/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.eventmanager.observers;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import mt.edu.um.cs.rv.eventmanager.engine.EventMessageSender;
import mt.edu.um.cs.rv.events.Event;
import mt.edu.um.cs.rv.events.builders.EventBuilder;
import mt.edu.um.cs.rv.events.builders.EventBuilderRegistry;
import mt.edu.um.cs.rv.events.triggers.Trigger;
import mt.edu.um.cs.rv.events.triggers.TriggerData;
import mt.edu.um.cs.rv.monitors.results.MonitorResult;
import mt.edu.um.cs.rv.monitors.results.MonitorResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.MessagingException;

public abstract class ExternalEventObserver<M, TD extends TriggerData, R>
implements Trigger {
    private static Logger LOGGER = LoggerFactory.getLogger(ExternalEventObserver.class);
    @Autowired
    EventBuilderRegistry eventBuilderRegistry;
    @Autowired
    EventMessageSender eventMessageSender;

    public final CompletableFuture<R> onMessage(M message) {
        LOGGER.debug("Generating TriggerData from Message [{}]", message);
        TD triggerData = this.generateTriggerData(message);
        LOGGER.debug("Generated TriggerData [{}] from Message [{}]", triggerData, message);
        LOGGER.debug("Computing whether event to be created from TriggerData [{}] should be a/synchronous", triggerData);
        Boolean shouldEventBeSynchronous = this.shouldEventBeSynchronous(triggerData);
        LOGGER.debug("Event should be {}", (Object)(shouldEventBeSynchronous != false ? "synchronous" : "asynchronous"));
        LOGGER.debug("Building event for TriggerData class [{}] in ExternalEventObserver type [{}]. Evaluating EventBuilders to use ...", (Object)triggerData.getClass().getTypeName(), (Object)this.getClass().getTypeName());
        List<EventBuilder> eventBuilders = this.eventBuilderRegistry.getBuilders(triggerData.getClass(), this.getClass());
        LOGGER.debug("Found [{}] EventBuilders for TriggerData class [{}] in ExternalEventObserver type [{}].", new Object[]{eventBuilders == null ? Integer.valueOf(0) : eventBuilders, triggerData.getClass().getTypeName(), this.getClass().getTypeName()});
        ArrayList monitorResultFutures = new ArrayList();
        for (EventBuilder eventBuilder : eventBuilders) {
            LOGGER.debug("Building new event using EventBuilder [{}] TriggerData class [{}] in ExternalEventObserver type [{}].", new Object[]{eventBuilder.getClass().getTypeName(), triggerData.getClass().getTypeName(), this.getClass().getTypeName()});
            Object event = eventBuilder.build(triggerData, shouldEventBeSynchronous);
            LOGGER.debug("Built new event {} using EventBuilder [{}] TriggerData class [{}] in ExternalEventObserver type [{}].", new Object[]{event, eventBuilders.getClass().getTypeName(), triggerData.getClass().getTypeName(), this.getClass().getTypeName()});
            Future<MonitorResult<?>> monitorResultFuture = null;
            LOGGER.debug("Checking whether event [{}] should be fired ...", event);
            if (eventBuilder.shouldFireEvent(event).booleanValue()) {
                LOGGER.debug("Event [{}] should be fired. Firing event ...", event);
                monitorResultFuture = this.fireEvent((Event)event);
            } else {
                LOGGER.debug("Event [{}] should not be fired.", event);
                monitorResultFuture = CompletableFuture.completedFuture(MonitorResult.ok());
            }
            monitorResultFutures.add(monitorResultFuture);
        }
        LOGGER.debug("Building chained CompletableFuture that will get the monitor result and generate the response.");
        return this.buildCompletableFuture(message, triggerData, monitorResultFutures);
    }

    private CompletableFuture<R> buildCompletableFuture(M m, TD triggerData, List<Future<MonitorResult<?>>> monitorResultFutures) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (monitorResultFutures == null || monitorResultFutures.isEmpty()) {
                    return MonitorResult.ok();
                }
                if (monitorResultFutures.size() == 1) {
                    return (MonitorResult)((Future)monitorResultFutures.get(0)).get();
                }
                MonitorResultList monitorResultList = new MonitorResultList();
                for (Future monitorResultFuture : monitorResultFutures) {
                    MonitorResult monitorResult = (MonitorResult)monitorResultFuture.get();
                    monitorResultList.addMonitorResult(monitorResult);
                }
                return monitorResultList;
            }
            catch (MessagingException me) {
                String msg = "Unexpected MessageException occurred";
                LOGGER.error("{}. Creating and returning a FAILURE MonitorResult.", (Object)msg, (Object)me);
                return MonitorResult.failure(null, me);
            }
            catch (Throwable throwable) {
                String msg = "Unexpected Throwable occurred";
                LOGGER.error("{}. Creating and returning a FAILURE MonitorResult.", (Object)msg, (Object)throwable);
                return MonitorResult.failure(null, throwable);
            }
        }).thenApply(monitorResult -> this.generateResponse(m, triggerData, (MonitorResult)monitorResult));
    }

    private Future<MonitorResult<?>> fireEvent(Event event) {
        return this.eventMessageSender.send(event);
    }

    public abstract TD generateTriggerData(M var1);

    public abstract R generateResponse(M var1, TD var2, MonitorResult var3);

    public Boolean shouldEventBeSynchronous(TD triggerData) {
        return false;
    }
}

