/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.events.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import mt.edu.um.cs.rv.events.builders.EventBuilder;
import mt.edu.um.cs.rv.events.triggers.TriggerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class EventBuilderRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBuilderRegistry.class);
    @Autowired(required=false)
    private List<EventBuilder> eventBuilders;
    private MultiValueMap<Class<? extends TriggerData>, EventBuilder> buildersMap;

    @PostConstruct
    public void init() {
        if (this.eventBuilders == null) {
            this.eventBuilders = new ArrayList<EventBuilder>();
        }
        this.buildersMap = new LinkedMultiValueMap();
        this.eventBuilders.stream().forEach(b -> this.buildersMap.add(b.forTriggerData(), b));
    }

    public List<EventBuilder> getBuilders(Class<? extends TriggerData> d) {
        return (List)this.buildersMap.get(d);
    }

    public List<EventBuilder> getBuilders(Class<? extends TriggerData> d, Object trigger) {
        return ((List)this.buildersMap.get(d)).stream().filter(eventBuilder -> {
            if (eventBuilder.forTrigger() == null) {
                return trigger == null;
            }
            return trigger.equals(eventBuilder.forTrigger());
        }).collect(Collectors.toList());
    }
}

