/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.scoping;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import mt.edu.um.cs.rv.scoping.AbstractValourScopeProvider;
import mt.edu.um.cs.rv.utils.ValourScriptTraverser;
import mt.edu.um.cs.rv.valour.Action;
import mt.edu.um.cs.rv.valour.ActionRef;
import mt.edu.um.cs.rv.valour.AdditionalTrigger;
import mt.edu.um.cs.rv.valour.Category;
import mt.edu.um.cs.rv.valour.CategoryRef;
import mt.edu.um.cs.rv.valour.Condition;
import mt.edu.um.cs.rv.valour.ConditionRef;
import mt.edu.um.cs.rv.valour.Declarations;
import mt.edu.um.cs.rv.valour.Event;
import mt.edu.um.cs.rv.valour.EventBody;
import mt.edu.um.cs.rv.valour.EventRef;
import mt.edu.um.cs.rv.valour.FormalParameters;
import mt.edu.um.cs.rv.valour.MonitorTrigger;
import mt.edu.um.cs.rv.valour.MonitorTriggerFire;
import mt.edu.um.cs.rv.valour.SimpleTrigger;
import mt.edu.um.cs.rv.valour.WhereClause;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ValourScopeProvider
extends AbstractValourScopeProvider {
    @Inject
    @Extension
    private ValourScriptTraverser _valourScriptTraverser;

    public IScope getScope(EObject context, EReference reference) {
        IScope iScope = super.getScope(context, reference);
        if (context instanceof EventRef) {
            return this.buildScopeForReference((EventRef)context, Event.class);
        }
        if (context instanceof ActionRef) {
            return this.buildScopeForReference((ActionRef)context, Action.class);
        }
        if (context instanceof CategoryRef) {
            return this.buildScopeForReference((CategoryRef)context, Category.class);
        }
        if (context instanceof ConditionRef) {
            return this.buildScopeForReference((ConditionRef)context, Condition.class);
        }
        if (context instanceof MonitorTriggerFire) {
            return this.buildScopeForMonitorTriggerFire((MonitorTriggerFire)context);
        }
        if (context instanceof WhereClause) {
            return this.buildScopeForWhereClause((WhereClause)context);
        }
        return iScope;
    }

    public <R extends EObject, X extends EObject> IScope buildScopeForReference(X context, Class<R> referencedType) {
        boolean _notEquals;
        ArrayList declarationsList = CollectionLiterals.newArrayList((Object[])new Declarations[0]);
        Declarations declarations = this._valourScriptTraverser.findClosestDeclaration(context);
        boolean bl = _notEquals = !Objects.equal((Object)declarations, null);
        if (_notEquals) {
            EObject _eContainer;
            EObject _eContainer_1;
            Declarations _findClosestDeclaration;
            do {
                declarationsList.add(declarations);
            } while (!Objects.equal((Object)(declarations = (_findClosestDeclaration = this._valourScriptTraverser.findClosestDeclaration(_eContainer_1 = (_eContainer = declarations.eContainer()).eContainer()))), null));
            IScope parent = IScope.NULLSCOPE;
            int i = declarationsList.size() - 1;
            while (i >= 0) {
                IScope _scopeFor;
                Declarations _get;
                declarations = _get = (Declarations)declarationsList.get(i);
                List candidates = EcoreUtil2.getAllContentsOfType((EObject)declarations, referencedType);
                parent = _scopeFor = Scopes.scopeFor((Iterable)candidates, (IScope)parent);
                --i;
            }
            return parent;
        }
        return null;
    }

    public <R extends EObject, X extends EObject> IScope buildScopeForMonitorTriggerFire(X context) {
        boolean _notEquals;
        ArrayList declarationsList = CollectionLiterals.newArrayList((Object[])new Declarations[0]);
        Declarations declarations = this._valourScriptTraverser.findClosestDeclaration(context);
        boolean bl = _notEquals = !Objects.equal((Object)declarations, null);
        if (_notEquals) {
            EObject _eContainer;
            EObject _eContainer_1;
            Declarations _findClosestDeclaration;
            do {
                declarationsList.add(declarations);
            } while (!Objects.equal((Object)(declarations = (_findClosestDeclaration = this._valourScriptTraverser.findClosestDeclaration(_eContainer_1 = (_eContainer = declarations.eContainer()).eContainer()))), null));
            IScope parent = IScope.NULLSCOPE;
            int i = declarationsList.size() - 1;
            while (i >= 0) {
                IScope _scopeFor;
                Declarations _get;
                declarations = _get = (Declarations)declarationsList.get(i);
                List _allContentsOfType = EcoreUtil2.getAllContentsOfType((EObject)declarations, Event.class);
                Functions.Function1 _function = e -> this.filterMonitorTriggers((Event)e);
                List _map = ListExtensions.map((List)_allContentsOfType, (Functions.Function1)_function);
                Iterable candidates = Iterables.concat((Iterable)_map);
                parent = _scopeFor = Scopes.scopeFor((Iterable)candidates, (IScope)parent);
                --i;
            }
            return parent;
        }
        return null;
    }

    public ArrayList<MonitorTrigger> filterMonitorTriggers(Event e) {
        EventBody eventBody = e.getEventBody();
        ArrayList monitorTriggerList = CollectionLiterals.newArrayList((Object[])new MonitorTrigger[0]);
        SimpleTrigger _trigger = eventBody.getTrigger();
        boolean _isMonitorTrigger = this.isMonitorTrigger(_trigger);
        if (_isMonitorTrigger) {
            SimpleTrigger _trigger_1 = eventBody.getTrigger();
            MonitorTrigger _monitorTrigger = _trigger_1.getMonitorTrigger();
            monitorTriggerList.add(_monitorTrigger);
        }
        AdditionalTrigger additionalTrigger = eventBody.getAdditionalTrigger();
        while (!Objects.equal((Object)additionalTrigger, null)) {
            AdditionalTrigger _additionalTrigger;
            SimpleTrigger _trigger_2 = additionalTrigger.getTrigger();
            boolean _isMonitorTrigger_1 = this.isMonitorTrigger(_trigger_2);
            if (_isMonitorTrigger_1) {
                SimpleTrigger _trigger_3 = additionalTrigger.getTrigger();
                MonitorTrigger _monitorTrigger_1 = _trigger_3.getMonitorTrigger();
                monitorTriggerList.add(_monitorTrigger_1);
            }
            additionalTrigger = _additionalTrigger = additionalTrigger.getAdditionalTrigger();
        }
        return monitorTriggerList;
    }

    public boolean isMonitorTrigger(SimpleTrigger st) {
        MonitorTrigger _monitorTrigger = st.getMonitorTrigger();
        return !Objects.equal((Object)_monitorTrigger, null);
    }

    public <R extends EObject, X extends EObject> IScope buildScopeForWhereClause(WhereClause whereClause) {
        boolean _notEquals;
        Event event = this._valourScriptTraverser.findFirstAncestorOfType(whereClause, Event.class);
        IScope scope = IScope.NULLSCOPE;
        boolean bl = _notEquals = !Objects.equal((Object)event, null);
        if (_notEquals) {
            IScope _scopeFor;
            FormalParameters _eventFormalParameters = event.getEventFormalParameters();
            EList<JvmFormalParameter> parameters = _eventFormalParameters.getParameters();
            scope = _scopeFor = Scopes.scopeFor(parameters, (IScope)scope);
        }
        return scope;
    }
}

