/*
 * Decompiled with CFR 0.152.
 */
package mt.edu.um.cs.rv.validation;

import com.google.common.base.Objects;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import mt.edu.um.cs.rv.utils.ValourScriptTraverser;
import mt.edu.um.cs.rv.validation.AbstractValourValidator;
import mt.edu.um.cs.rv.valour.ActualParameters;
import mt.edu.um.cs.rv.valour.BasicRule;
import mt.edu.um.cs.rv.valour.CategorisationClause;
import mt.edu.um.cs.rv.valour.Category;
import mt.edu.um.cs.rv.valour.CategoryRef;
import mt.edu.um.cs.rv.valour.Declaration;
import mt.edu.um.cs.rv.valour.Declarations;
import mt.edu.um.cs.rv.valour.Event;
import mt.edu.um.cs.rv.valour.EventBody;
import mt.edu.um.cs.rv.valour.EventRef;
import mt.edu.um.cs.rv.valour.ExternalTrigger;
import mt.edu.um.cs.rv.valour.ForEach;
import mt.edu.um.cs.rv.valour.FormalParameters;
import mt.edu.um.cs.rv.valour.Rule;
import mt.edu.um.cs.rv.valour.Rules;
import mt.edu.um.cs.rv.valour.ValourBody;
import mt.edu.um.cs.rv.valour.ValourPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ValourValidator
extends AbstractValourValidator {
    @Inject
    @Extension
    private ValourScriptTraverser _valourScriptTraverser;

    @Check
    public void checkEventRefParameterCount(EventRef eventRef) {
        FormalParameters _eventFormalParameters_1;
        EList<JvmFormalParameter> _parameters_2;
        boolean _isNullOrEmpty_1;
        boolean _not_1;
        boolean _notEquals_1;
        ActualParameters _eventActualParameters_1;
        EList<XExpression> _parameters;
        boolean _isNullOrEmpty;
        boolean _not;
        boolean _notEquals;
        EList _eCrossReferences = eventRef.eCrossReferences();
        EObject _get = (EObject)_eCrossReferences.get(0);
        Event e = (Event)_get;
        int actualParameterCount = 0;
        boolean _and = false;
        ActualParameters _eventActualParameters = eventRef.getEventActualParameters();
        boolean bl = _notEquals = !Objects.equal((Object)_eventActualParameters, null);
        _and = !_notEquals ? false : (_not = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty(_parameters = (_eventActualParameters_1 = eventRef.getEventActualParameters()).getParameters())));
        if (_and) {
            int _size;
            ActualParameters _eventActualParameters_2 = eventRef.getEventActualParameters();
            EList<XExpression> _parameters_1 = _eventActualParameters_2.getParameters();
            actualParameterCount = _size = _parameters_1.size();
        }
        int formalParameterCount = 0;
        boolean _and_1 = false;
        FormalParameters _eventFormalParameters = e.getEventFormalParameters();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_eventFormalParameters, null);
        _and_1 = !_notEquals_1 ? false : (_not_1 = !(_isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty(_parameters_2 = (_eventFormalParameters_1 = e.getEventFormalParameters()).getParameters())));
        if (_and_1) {
            int _size_1;
            FormalParameters _eventFormalParameters_2 = e.getEventFormalParameters();
            EList<JvmFormalParameter> _parameters_3 = _eventFormalParameters_2.getParameters();
            formalParameterCount = _size_1 = _parameters_3.size();
        }
        if (actualParameterCount != formalParameterCount) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"Bad parameter count for event ");
            String _name = e.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)": Expected ");
            _builder.append((Object)formalParameterCount, "");
            _builder.append((Object)" but found ");
            _builder.append((Object)actualParameterCount, "");
            String msg = _builder.toString();
            this.error(msg, (EStructuralFeature)ValourPackage.Literals.EVENT_REF__EVENT_REF_ID);
        }
    }

    @Check
    public void checkEventDeclarationUniqueness(Event event) {
        boolean _notEquals;
        Declarations declarations = this._valourScriptTraverser.findClosestDeclaration(event);
        boolean bl = _notEquals = !Objects.equal((Object)declarations, null);
        if (_notEquals) {
            EObject _eContainer;
            EObject _eContainer_1;
            Declarations _findClosestDeclaration;
            do {
                boolean _not;
                Functions.Function1 _function_3;
                EList<Declaration> _declarations = declarations.getDeclarations();
                Functions.Function1 _function = d -> {
                    Event _event = d.getEvent();
                    return !Objects.equal((Object)_event, null);
                };
                Iterable _filter = IterableExtensions.filter(_declarations, (Functions.Function1)_function);
                Functions.Function1 _function_1 = d -> d.getEvent();
                Iterable events = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
                Functions.Function1 _function_2 = e -> {
                    boolean _equals = e.equals(event);
                    return !_equals;
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)events, (Functions.Function1)_function_2);
                Iterable errors = IterableExtensions.filter((Iterable)(events = _filter_1), (Functions.Function1)(_function_3 = e -> {
                    String _name = e.getName();
                    String _name_1 = event.getName();
                    return _name.equals(_name_1);
                }));
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)errors);
                boolean bl2 = _not = !_isNullOrEmpty;
                if (!_not) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Duplicate event with name ");
                String _name = event.getName();
                _builder.append((Object)_name, "");
                String msg = _builder.toString();
                this.error(msg, (EStructuralFeature)ValourPackage.Literals.EVENT__NAME);
                Consumer<Event> _function_4 = e -> this.error(msg, (EObject)e, (EStructuralFeature)ValourPackage.Literals.EVENT__NAME);
                errors.forEach(_function_4);
            } while (!Objects.equal((Object)(declarations = (_findClosestDeclaration = this._valourScriptTraverser.findClosestDeclaration(_eContainer_1 = (_eContainer = declarations.eContainer()).eContainer()))), null));
        }
    }

    @Check
    public void checkForEachBlocksOnlyUseEventsWithTheRightCategorisation(ForEach forEach) {
        CategoryRef _category = forEach.getCategory();
        Category forEachCategory = _category.getCategory();
        ValourBody _valourBody = forEach.getValourBody();
        Rules _rules = _valourBody.getRules();
        EList<Rule> rules = _rules.getRules();
        for (Rule r : rules) {
            boolean _notEquals_1;
            boolean _notEquals;
            BasicRule basicRule = r.getBasicRule();
            boolean bl = _notEquals = !Objects.equal((Object)basicRule, null);
            if (!_notEquals) continue;
            EventRef event = basicRule.getEvent();
            Event _eventRefId = event.getEventRefId();
            EventBody _eventBody = _eventRefId.getEventBody();
            CategorisationClause eventCategorisation = _eventBody.getCategorisation();
            boolean _or = false;
            boolean _equals = Objects.equal((Object)eventCategorisation, null);
            if (_equals) {
                _or = true;
            } else {
                boolean _equals_1;
                CategoryRef _category_1 = eventCategorisation.getCategory();
                _or = _equals_1 = Objects.equal((Object)_category_1, null);
            }
            if (_or) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Event ");
                Event _eventRefId_1 = event.getEventRefId();
                _builder.append((Object)_eventRefId_1, "");
                _builder.append((Object)" cannot be used within a for-each constructor without declaring which category it belongs to");
                String msg = _builder.toString();
                this.error(msg, (EStructuralFeature)ValourPackage.Literals.FOR_EACH__VALOUR_BODY);
                continue;
            }
            CategoryRef _category_2 = eventCategorisation.getCategory();
            Category _category_3 = _category_2.getCategory();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_category_3, (Object)forEachCategory);
            if (!_notEquals_1) continue;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"Event ");
            Event _eventRefId_2 = event.getEventRefId();
            String _name = _eventRefId_2.getName();
            _builder_1.append((Object)_name, "");
            _builder_1.append((Object)" declares a different type of category [");
            CategoryRef _category_4 = eventCategorisation.getCategory();
            Category _category_5 = _category_4.getCategory();
            String _name_1 = _category_5.getName();
            _builder_1.append((Object)_name_1, "");
            _builder_1.append((Object)"], while the current for-each constructor expects category of [");
            String _name_2 = forEachCategory.getName();
            _builder_1.append((Object)_name_2, "");
            _builder_1.append((Object)"]");
            String msg_1 = _builder_1.toString();
            this.error(msg_1, r, (EStructuralFeature)ValourPackage.Literals.RULE__BASIC_RULE);
        }
    }

    @Check
    public void externalTriggerShouldExtendTrigger(ExternalTrigger externalTrigger) {
        Functions.Function1 _function;
        JvmType _type_1;
        JvmDeclaredType declaredType;
        EList _superTypes;
        List _map;
        boolean valid;
        JvmTypeReference triggerClassRef = externalTrigger.getTriggerClass();
        JvmType _type = triggerClassRef.getType();
        if (_type instanceof JvmDeclaredType && !(valid = (_map = ListExtensions.map((List)(_superTypes = (declaredType = (JvmDeclaredType)(_type_1 = triggerClassRef.getType())).getSuperTypes()), (Functions.Function1)(_function = st -> {
            JvmType _type_2 = st.getType();
            return _type_2.getQualifiedName();
        }))).contains("mt.edu.um.cs.rv.eventmanager.observers.ExternalEventObserver"))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"External Event Trigger should have a class that extends from mt.edu.um.cs.rv.eventmanager.observers.ExternalEventObserver as an event trigger class");
            String msg = _builder.toString();
            this.error(msg, (EStructuralFeature)ValourPackage.Literals.EXTERNAL_TRIGGER__TRIGGER_CLASS);
        }
    }

    @Check
    public void externalTriggerDataShouldExtendTriggerData(ExternalTrigger externalTrigger) {
        Functions.Function1 _function;
        JvmType _type_1;
        JvmDeclaredType declaredType;
        EList _superTypes;
        List _map;
        boolean valid;
        JvmTypeReference dataClassRef = externalTrigger.getDataClass();
        JvmType _type = dataClassRef.getType();
        if (_type instanceof JvmDeclaredType && !(valid = (_map = ListExtensions.map((List)(_superTypes = (declaredType = (JvmDeclaredType)(_type_1 = dataClassRef.getType())).getSuperTypes()), (Functions.Function1)(_function = st -> {
            JvmType _type_2 = st.getType();
            return _type_2.getQualifiedName();
        }))).contains("mt.edu.um.cs.rv.events.triggers.TriggerData"))) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"External Event Trigger Data should have a class that extends from mt.edu.um.cs.rv.events.triggers.TriggerData as an event trigger data class");
            String msg = _builder.toString();
            this.error(msg, (EStructuralFeature)ValourPackage.Literals.EXTERNAL_TRIGGER__DATA_CLASS);
        }
    }
}

