/*
 * Decompiled with CFR 0.152.
 */
package name.jervyshi.nacos;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import name.jervyshi.nacos.NacosPortsBuilder;
import name.jervyshi.nacos.NacosStarter;
import name.jervyshi.nacos.exception.NacosEmbeddedException;
import name.jervyshi.nacos.infra.NacosVersionGetter;

public class NacosStarterBuilder {
    private Path downloadPath;
    private String nacosVersion;
    private String host;
    private NacosPortsBuilder nacosPortsBuilder = NacosPortsBuilder.nacosPorts();

    private NacosStarterBuilder() {
    }

    public static NacosStarterBuilder nacosStarter() {
        return new NacosStarterBuilder();
    }

    public NacosStarterBuilder withDownloadPath(Path downloadPath) {
        this.downloadPath = downloadPath;
        return this;
    }

    public NacosStarterBuilder withNacosVersion(String nacosVersion) {
        this.nacosVersion = nacosVersion;
        return this;
    }

    public NacosStarterBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public NacosStarterBuilder withServerPort(int serverPort) {
        this.nacosPortsBuilder.withServerPort(serverPort);
        return this;
    }

    public NacosStarter build() {
        this.applyDefaults();
        return new NacosStarter(this.nacosVersion, this.downloadPath, this.host, this.nacosPortsBuilder.build());
    }

    private void applyDefaults() {
        try {
            if (this.nacosVersion == null || this.nacosVersion.equals("") || this.nacosVersion.equals("latest")) {
                this.nacosVersion = NacosVersionGetter.getLatestVersion();
            }
            if (this.downloadPath == null) {
                this.downloadPath = Paths.get(Files.createTempDirectory("", new FileAttribute[0]).getParent().toString(), "nacos-embedded-" + this.nacosVersion);
            }
            if (this.host == null || this.host.equals("")) {
                this.host = "127.0.0.1";
            }
            if (!Files.exists(this.downloadPath, new LinkOption[0])) {
                Files.createDirectories(this.downloadPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new NacosEmbeddedException("apply default settings error", e);
        }
    }
}

