/*
 * Decompiled with CFR 0.152.
 */
package name.jervyshi.nacos.infra;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import name.jervyshi.nacos.exception.NacosEmbeddedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosBinaryDownloader {
    public static final String NACOS_BINARY_URL = "https://github.com/alibaba/nacos/releases/download/%s/nacos-server-%s.zip";
    private static final Logger logger = LoggerFactory.getLogger(NacosBinaryDownloader.class);

    public static File getNacosBinaryArchive(String version, Path filePath) {
        try {
            URL url = new URL(String.format(NACOS_BINARY_URL, version, version));
            InputStream inputStream = url.openStream();
            Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
            return filePath.toFile();
        }
        catch (Exception e) {
            logger.error("get nacos binary archive failed, version: {}, filePath: {}", new Object[]{version, filePath, e});
            throw new NacosEmbeddedException("get nacos binary archive failed", e);
        }
    }
}

