/*
 * Decompiled with CFR 0.152.
 */
package name.kazennikov.logger;

import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;

public class Logger {
    org.apache.log4j.Logger logger;

    private Logger() {
        this.logger = org.apache.log4j.Logger.getLogger((String)Logger.getCallerClassName());
    }

    private Logger(Class<?> clazz) {
        this.logger = org.apache.log4j.Logger.getLogger(clazz);
    }

    private Logger(String name) {
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    private Logger(String name, LoggerFactory factory) {
        this.logger = org.apache.log4j.Logger.getLogger((String)name, (LoggerFactory)factory);
    }

    private static String getCallerClassName() {
        StackTraceElement[] st = new Exception().getStackTrace();
        return st.length > 3 ? st[3].getClassName() : "logger";
    }

    public static Logger getLogger() {
        return new Logger();
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }

    public static Logger getLogger(String name) {
        return new Logger(name);
    }

    public static Logger getLogger(String name, LoggerFactory factory) {
        return new Logger(name, factory);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void trace(String format, Object ... objects) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format(format, objects));
        }
    }

    public void trace(String format, Throwable e, Object ... objects) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format(format, objects), e);
        }
    }

    public void debug(String format, Object ... objects) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format(format, objects));
        }
    }

    public void debug(String format, Throwable e, Object ... objects) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format(format, objects), e);
        }
    }

    public void info(String format, Object ... objects) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format(format, objects));
        }
    }

    public void info(String format, Throwable e, Object ... objects) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)String.format(format, objects), e);
        }
    }

    public void warn(String format, Object ... objects) {
        if (this.logger.isEnabledFor(Priority.WARN)) {
            this.logger.warn((Object)String.format(format, objects));
        }
    }

    public void warn(String format, Throwable e, Object ... objects) {
        if (this.logger.isEnabledFor(Priority.WARN)) {
            this.logger.warn((Object)String.format(format, objects), e);
        }
    }

    public void error(Throwable e) {
        if (this.logger.isEnabledFor(Priority.ERROR)) {
            this.logger.error((Object)e);
        }
    }

    public void error(String format, Object ... objects) {
        if (this.logger.isEnabledFor(Priority.ERROR)) {
            this.logger.error((Object)String.format(format, objects));
        }
    }

    public void error(String format, Throwable e, Object ... objects) {
        if (this.logger.isEnabledFor(Priority.ERROR)) {
            this.logger.error((Object)String.format(format, objects), e);
        }
    }

    public void fatal(String format, Object ... objects) {
        if (this.logger.isEnabledFor(Priority.FATAL)) {
            this.logger.fatal((Object)String.format(format, objects));
        }
    }

    public void fatal(String format, Throwable e, Object ... objects) {
        if (this.logger.isEnabledFor(Priority.FATAL)) {
            this.logger.fatal((Object)String.format(format, objects), e);
        }
    }

    public void trace(Throwable e) {
        if (this.logger.isTraceEnabled()) {
            this.logger.fatal((Object)e);
        }
    }

    public void info(Throwable e) {
        if (this.logger.isEnabledFor(Priority.INFO)) {
            this.logger.fatal((Object)e);
        }
    }

    public void debug(Throwable e) {
        if (this.logger.isEnabledFor(Priority.DEBUG)) {
            this.logger.fatal((Object)e);
        }
    }

    public void warn(Throwable e) {
        if (this.logger.isEnabledFor(Priority.WARN)) {
            this.logger.warn((Object)e);
        }
    }

    public void fatal(Throwable e) {
        if (this.logger.isEnabledFor(Priority.FATAL)) {
            this.logger.fatal((Object)e);
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor(Priority.WARN);
    }
}

