/*
 * Decompiled with CFR 0.152.
 */
package name.lecaroz.java.swing.jocheckboxtree;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Vector;
import javax.swing.tree.TreePath;
import name.lecaroz.java.swing.jocheckboxtree.DefaultTreeCheckingModel;
import name.lecaroz.java.swing.jocheckboxtree.DependenciesModel;
import name.lecaroz.java.swing.jocheckboxtree.TreeCheckingMode;
import name.lecaroz.java.swing.jocheckboxtree.TreeNodeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropagatePreservingCheckDependenciesTreeCheckingMode<E>
extends TreeCheckingMode {
    private final DependenciesModel<E> dependencies;

    public PropagatePreservingCheckDependenciesTreeCheckingMode(DefaultTreeCheckingModel defaultTreeCheckingModel, DependenciesModel<E> dependencies) {
        super(defaultTreeCheckingModel);
        this.dependencies = dependencies;
    }

    private void doCheckPath(TreePath path) {
        this.model.checkSubTree(path);
        TreePath[] parents = new TreePath[path.getPathCount()];
        parents[0] = path;
        boolean uncheckAll = false;
        boolean greyAll = false;
        block5: for (int i = 1; i < parents.length; ++i) {
            parents[i] = parents[i - 1].getParentPath();
            if (parents[i].getLastPathComponent() instanceof TreeNodeObject && !((TreeNodeObject)parents[i].getLastPathComponent()).canBeChecked()) continue;
            if (uncheckAll) {
                this.model.removeFromCheckedPathsSet(parents[i]);
                if (greyAll) {
                    this.model.addToGreyedPathsSet(parents[i]);
                    continue;
                }
                if (this.model.pathHasUncheckedChildren(parents[i])) {
                    this.model.addToGreyedPathsSet(parents[i]);
                    greyAll = true;
                    continue;
                }
                this.model.removeFromGreyedPathsSet(parents[i]);
                continue;
            }
            switch (this.model.getChildrenChecking(parents[i])) {
                case HALF_CHECKED: {
                    this.model.removeFromCheckedPathsSet(parents[i]);
                    this.model.addToGreyedPathsSet(parents[i]);
                    uncheckAll = true;
                    greyAll = true;
                    continue block5;
                }
                case ALL_UNCHECKED: {
                    this.model.removeFromCheckedPathsSet(parents[i]);
                    this.model.removeFromGreyedPathsSet(parents[i]);
                    uncheckAll = true;
                    continue block5;
                }
                case ALL_CHECKED: {
                    this.model.addToCheckedPathsSet(parents[i]);
                    this.model.removeFromGreyedPathsSet(parents[i]);
                    continue block5;
                }
                default: {
                    System.err.println("This should not happen (PropagatePreservingCheckTreeCheckingMode)");
                }
            }
        }
    }

    @Override
    public void checkPath(TreePath path) {
        this.doCheckPath(path);
        Vector<Object> toCheck = new Vector<Object>();
        if (path.getLastPathComponent() instanceof TreeNodeObject) {
            ((AbstractList)toCheck).add(((TreeNodeObject)path.getLastPathComponent()).getObject());
        } else {
            this.doCheckPath(path);
        }
        for (int pos = 0; pos < ((AbstractCollection)toCheck).size(); ++pos) {
            Object element = ((AbstractList)toCheck).get(pos);
            E[] dependenciesElements = this.dependencies.dependencies(element);
            if (dependenciesElements == null) continue;
            for (E e : dependenciesElements) {
                if (((AbstractCollection)toCheck).contains(e)) continue;
                ((AbstractList)toCheck).add(e);
            }
        }
        TreePath parent = path;
        while (parent.getParentPath() != null) {
            parent = parent.getParentPath();
        }
        Vector<TreePath> paths = new Vector<TreePath>();
        paths.add(parent);
        for (int pos = 0; pos < paths.size(); ++pos) {
            for (TreePath treePath : this.model.getChildrenPath((TreePath)paths.get(pos))) {
                if (treePath.getLastPathComponent() instanceof TreeNodeObject && ((TreeNodeObject)treePath.getLastPathComponent()).canBeChecked() && ((TreeNodeObject)treePath.getLastPathComponent()).isEnabled() && !this.model.isPathChecked(treePath) && ((AbstractCollection)toCheck).contains(((TreeNodeObject)treePath.getLastPathComponent()).getObject())) {
                    this.doCheckPath(treePath);
                }
                paths.add(treePath);
            }
        }
    }

    private void doUncheckPath(TreePath path) {
        this.model.uncheckSubTree(path);
        TreePath parentPath = path;
        while ((parentPath = parentPath.getParentPath()) != null) {
            this.model.removeFromCheckedPathsSet(parentPath);
            this.model.updatePathGreyness(parentPath);
        }
    }

    @Override
    public void uncheckPath(TreePath path) {
        this.doUncheckPath(path);
        Vector<Object> toUncheck = new Vector<Object>();
        if (path.getLastPathComponent() instanceof TreeNodeObject) {
            ((AbstractList)toUncheck).add(((TreeNodeObject)path.getLastPathComponent()).getObject());
        }
        for (int pos = 0; pos < ((AbstractCollection)toUncheck).size(); ++pos) {
            Object element = ((AbstractList)toUncheck).get(pos);
            E[] parents = this.dependencies.parents(element);
            if (parents == null) continue;
            for (E parent : parents) {
                if (((AbstractCollection)toUncheck).contains(parent)) continue;
                ((AbstractList)toUncheck).add(parent);
            }
        }
        for (TreePath childPath : this.model.getCheckingPaths()) {
            Object childPathComponent = childPath.getLastPathComponent();
            if (!(childPathComponent instanceof TreeNodeObject) || !((TreeNodeObject)childPathComponent).canBeChecked() || !((TreeNodeObject)childPathComponent).isEnabled() || !((AbstractCollection)toUncheck).contains(((TreeNodeObject)childPathComponent).getObject())) continue;
            this.doUncheckPath(childPath);
        }
    }

    @Override
    public void updateCheckAfterChildrenInserted(TreePath parent) {
        if (this.model.isPathChecked(parent)) {
            this.checkPath(parent);
        } else {
            this.uncheckPath(parent);
        }
    }

    @Override
    public void updateCheckAfterChildrenRemoved(TreePath parent) {
        if (!this.model.isPathChecked(parent) && this.model.getChildrenPath(parent).length != 0 && !this.model.pathHasChildrenWithValue(parent, false)) {
            this.checkPath(parent);
        }
        this.model.updatePathGreyness(parent);
        this.model.updateAncestorsGreyness(parent);
    }

    @Override
    public void updateCheckAfterStructureChanged(TreePath parent) {
        if (this.model.isPathChecked(parent)) {
            this.checkPath(parent);
        } else {
            this.uncheckPath(parent);
        }
    }
}

