/*
 * Decompiled with CFR 0.152.
 */
package name.lecaroz.java.swing.jocheckboxtree.examples;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import name.lecaroz.java.swing.jocheckboxtree.CheckboxTree;
import name.lecaroz.java.swing.jocheckboxtree.TreeCheckingModel;

public class LookAndFeelExample
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -5597477524261243939L;
    private CheckboxTree checkboxTree = null;
    private JPanel jContentPane = null;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    System.out.println(info);
                }
                System.out.println("Cross-platform L&F: " + UIManager.getCrossPlatformLookAndFeelClassName());
                LookAndFeelExample.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        try {
            String lafName = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
            System.out.println("Setting the L&F to " + lafName);
            UIManager.setLookAndFeel(lafName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        LookAndFeelExample frame = new LookAndFeelExample();
        frame.pack();
        frame.setVisible(true);
    }

    public LookAndFeelExample() {
        this.setContentPane(this.getJContentPane());
        this.setTitle("CheckboxTree");
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getLAFMenuBar());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getCheckboxTree(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getCheckboxTree() {
        if (this.checkboxTree == null) {
            this.checkboxTree = new CheckboxTree();
            this.checkboxTree.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.PROPAGATE);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.checkboxTree.getModel().getRoot();
            DefaultMutableTreeNode ravioli = (DefaultMutableTreeNode)root.getChildAt(2).getChildAt(2);
            ravioli.add(new DefaultMutableTreeNode("al tartufo"));
            ravioli.add(new DefaultMutableTreeNode("alla salvia"));
            for (int i = 2; i < 10; ++i) {
                ravioli.add(new DefaultMutableTreeNode("ai " + i + " formaggi"));
            }
            ((DefaultTreeModel)this.checkboxTree.getModel()).nodeStructureChanged(root);
            this.checkboxTree.addCheckingPath(new TreePath(ravioli.getPath()));
            this.checkboxTree.expandAll();
        }
        return new JScrollPane(this.checkboxTree);
    }

    private JMenuBar getLAFMenuBar() {
        JMenuBar retVal = new JMenuBar();
        JMenu lafMenu = new JMenu("Look&Feel");
        retVal.add(lafMenu);
        JRadioButtonMenuItem radioAction3 = new JRadioButtonMenuItem("System");
        radioAction3.setSelected(true);
        JRadioButtonMenuItem radioAction1 = new JRadioButtonMenuItem("Metal-default-theme");
        JRadioButtonMenuItem radioAction2 = new JRadioButtonMenuItem("Metal-ocean-theme");
        JRadioButtonMenuItem radioAction4 = new JRadioButtonMenuItem("CDE/Motif");
        JRadioButtonMenuItem radioAction5 = new JRadioButtonMenuItem("GTK");
        JRadioButtonMenuItem radioAction6 = new JRadioButtonMenuItem("Nimbus");
        ButtonGroup bg = new ButtonGroup();
        bg.add(radioAction1);
        bg.add(radioAction2);
        bg.add(radioAction3);
        bg.add(radioAction4);
        bg.add(radioAction5);
        bg.add(radioAction6);
        lafMenu.add(radioAction1);
        lafMenu.add(radioAction2);
        lafMenu.add(radioAction3);
        lafMenu.add(radioAction4);
        lafMenu.add(radioAction5);
        lafMenu.add(radioAction6);
        radioAction1.addActionListener(this);
        radioAction2.addActionListener(this);
        radioAction3.addActionListener(this);
        radioAction4.addActionListener(this);
        radioAction5.addActionListener(this);
        radioAction6.addActionListener(this);
        return retVal;
    }

    public void actionPerformed(ActionEvent action) {
        String actionName = action.getActionCommand();
        String lafName = null;
        if (actionName.equals("Metal-default-theme")) {
            lafName = "javax.swing.plaf.metal.MetalLookAndFeel";
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        } else if (actionName.equals("Metal-ocean-theme")) {
            lafName = "javax.swing.plaf.metal.MetalLookAndFeel";
            MetalLookAndFeel.setCurrentTheme(new OceanTheme());
        } else if (actionName.equals("System")) {
            lafName = UIManager.getSystemLookAndFeelClassName();
        } else if (actionName.equals("CDE/Motif")) {
            lafName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        } else if (actionName.equals("GTK")) {
            lafName = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
        } else if (actionName.equals("Nimbus")) {
            lafName = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
        }
        try {
            System.out.println("Setting the L&F to " + lafName);
            UIManager.setLookAndFeel(lafName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Couldn't find class for specified look and feel: " + lafName);
            System.err.println("Did you include the L&F library in the class path?");
            System.err.println("Using the default look and feel.");
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println("Can't use the specified look and feel (" + lafName + ") on this platform.");
            System.err.println("Using the default look and feel.");
        }
        catch (Exception e) {
            System.err.println("Couldn't get specified look and feel (" + lafName + "), for some reason.");
            System.err.println("Using the default look and feel.");
            e.printStackTrace();
        }
    }
}

