/*
 * Decompiled with CFR 0.152.
 */
package name.lecaroz.java.swing.sun.examples;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import name.lecaroz.java.swing.jocheckboxtree.CheckboxTree;
import name.lecaroz.java.swing.jocheckboxtree.DefaultTreeCheckingModel;
import name.lecaroz.java.swing.jocheckboxtree.DependenciesModel;
import name.lecaroz.java.swing.jocheckboxtree.ExtendedAbstractTreeTableModel;
import name.lecaroz.java.swing.jocheckboxtree.ExtendedTreeTableModel;
import name.lecaroz.java.swing.jocheckboxtree.PropagatePreservingCheckDependenciesTreeCheckingMode;
import name.lecaroz.java.swing.jocheckboxtree.TreeNodeObject;
import name.lecaroz.java.swing.sun.JOCheckboxTreeTable;

public class JOCheckboxTreeTableExample
extends JFrame {
    private static final long serialVersionUID = 4421111660963742252L;

    public JOCheckboxTreeTableExample() {
        StringNode root = new StringNode("0", true, new StringNode[]{new StringNode("1", true, new StringNode[]{new StringNode("1.1", false, null), new StringNode("1.2", false, null)}), new StringNode("2", true, new StringNode[]{new StringNode("2.1", false, null), new StringNode("2.2", false, null)}), new StringNode("3", true, new StringNode[]{new StringNode("3.1", false, null), new StringNode("3.2", false, null)}), new StringNode("4", true, new StringNode[]{new StringNode("4.1", false, null), new StringNode("4.2", false, null)})});
        SampleDataTreeModel dataModel = new SampleDataTreeModel(root);
        JOCheckboxTreeTable checkboxTreeTable = new JOCheckboxTreeTable(dataModel);
        DependenciesModel<String> dependencies = new StringDependencies().addDependency("1", "2").addDependency("1", "4").addDependency("3", "4");
        ((CheckboxTree)checkboxTreeTable.getTree()).getCheckingModel().setCheckingMode(new PropagatePreservingCheckDependenciesTreeCheckingMode<String>((DefaultTreeCheckingModel)((CheckboxTree)checkboxTreeTable.getTree()).getCheckingModel(), dependencies));
        JScrollPane treeTablePane = new JScrollPane(checkboxTreeTable);
        this.getContentPane().add((Component)treeTablePane, "Center");
        this.setMinimumSize(new Dimension(400, 400));
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) throws IOException {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    JOCheckboxTreeTableExample frame = new JOCheckboxTreeTableExample();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StringDependencies
    implements DependenciesModel<String> {
        final AbstractMap<String, AbstractList<String>> dependenciesMap = new HashMap<String, AbstractList<String>>();
        final AbstractMap<String, AbstractList<String>> parentsMap = new HashMap<String, AbstractList<String>>();

        private void add(AbstractMap<String, AbstractList<String>> map, String key, String dependency) {
            Vector<String> elements = (Vector<String>)map.get(key);
            if (elements == null) {
                elements = new Vector<String>();
                map.put(key, elements);
            }
            if (!elements.contains(dependency)) {
                elements.add(dependency);
            }
        }

        @Override
        public DependenciesModel<String> addDependency(String entry, String dependency) {
            this.add(this.dependenciesMap, entry, dependency);
            this.add(this.parentsMap, dependency, entry);
            return this;
        }

        @Override
        public boolean isDependency(String node, String dependency) {
            return this.dependenciesMap.containsKey(node) ? this.dependenciesMap.get(node).contains(dependency) : false;
        }

        public String[] parents(String node) {
            AbstractList<String> parents = this.parentsMap.get(node);
            return parents != null ? parents.toArray(new String[0]) : null;
        }

        public String[] dependencies(String node) {
            AbstractList<String> dependencies = this.dependenciesMap.get(node);
            return dependencies != null ? dependencies.toArray(new String[0]) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SampleDataTreeModel
    extends ExtendedAbstractTreeTableModel
    implements ExtendedTreeTableModel {
        private final String[] cNames;
        private final Class<?>[] cTypes;

        public SampleDataTreeModel(Object root) {
            super(root);
            this.cNames = new String[]{"Name", "Description"};
            this.cTypes = new Class[]{ExtendedTreeTableModel.class, String.class};
        }

        public Object getChild(Object node, int i) {
            return this.getChildren(node)[i];
        }

        private StringNode[] getChildren(Object node) {
            return ((StringNode)node).getChildren();
        }

        public int getChildCount(Object node) {
            StringNode[] children = this.getChildren(node);
            return children == null ? 0 : children.length;
        }

        public int getColumnCount() {
            return this.cNames.length;
        }

        public String getColumnName(int column) {
            return this.cNames[column];
        }

        public Class<?> getColumnClass(int column) {
            return this.cTypes[column];
        }

        public Object getValueAt(Object node, int column) {
            String data = this.getObject(node);
            switch (column) {
                case 0: {
                    if (data.equals("0")) {
                        return "All";
                    }
                    return "" + data.toString();
                }
                case 1: {
                    return "Description: " + data.toString();
                }
            }
            return null;
        }

        @Override
        public String getTooltipAt(Object node, int column) {
            switch (column) {
                case 0: {
                    return "Tooltip: " + ((TreeNodeObject)node).getObject().toString();
                }
                case 1: {
                    return "Description tooltip: " + ((TreeNodeObject)node).getObject().toString();
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, Object treeNodeObject, int column) {
        }

        @Override
        public String getObject(Object node) {
            return (String)((TreeNodeObject)node).getObject();
        }

        public int getHierarchicalColumn() {
            return 0;
        }

        public int getIndexOfChild(Object arg0, Object arg1) {
            return 0;
        }

        @Override
        public void doubleClicked(Object treeNodeObject, int column) {
            System.out.println("double clicked");
        }
    }

    public class StringNode
    implements TreeNodeObject {
        private final String data;
        private final boolean canBeChecked;
        private final StringNode[] childs;
        private final Icon icon;

        StringNode(String data, boolean canBeChecked, StringNode[] childs) {
            this.data = data;
            this.canBeChecked = canBeChecked;
            this.childs = childs;
            ImageIcon tmpIcon = null;
            try {
                InputStream stream = this.getClass().getResourceAsStream("/images/" + data + ".png");
                if (stream != null) {
                    tmpIcon = new ImageIcon(ImageIO.read(stream));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.icon = tmpIcon != null ? new ImageIcon(((ImageIcon)tmpIcon).getImage().getScaledInstance(((ImageIcon)UIManager.get("Tree.openIcon")).getIconWidth(), ((ImageIcon)UIManager.get("Tree.openIcon")).getIconWidth(), 4)) : null;
        }

        public String getObject() {
            return this.data;
        }

        public boolean canBeChecked() {
            return this.canBeChecked;
        }

        public Component getTreeCellRendererComponent(JTree tree, TreeCellRenderer treeCellRenderer, DefaultTreeCellRenderer label, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            label.getTreeCellRendererComponent(tree, this.getObject().toString().equals("0") ? "All" : this.getObject(), selected, expanded, leaf, row, hasFocus);
            label.setIcon(this.icon);
            return null;
        }

        public StringNode[] getChildren() {
            return this.childs;
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

