/*
 * Copyright 2017 Mikhail Lopatkin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package name.mlopatkin.bitbucket.api;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

import name.mlopatkin.bitbucket.api.rest.RepositoryEndpoint;

import java.io.File;
import java.util.concurrent.CompletableFuture;

class RepositoryImpl implements Repository {
    private final RepositoryEndpoint mEndpoint;
    private final String mUsername;
    private final String mRepositoryName;

    public RepositoryImpl(RepositoryEndpoint endpoint, String username, String repositoryName) {
        mEndpoint = endpoint;
        mUsername = username;
        mRepositoryName = repositoryName;
    }

    @Override
    public CompletableFuture<Void> addDownloadFromFile(File file) {
        RequestBody requestBody =
                MultipartBody.create(MediaType.parse("application/octet-stream"), file);
        return mEndpoint.createDownload(mUsername, mRepositoryName, MultipartBody.Part
                .createFormData("files", file.getName(), requestBody));
    }
}
