/*
 * Copyright 2017 Mikhail Lopatkin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package name.mlopatkin.bitbucket.api;

import java.io.File;
import java.util.concurrent.CompletableFuture;

/**
 * This class represents a repository on Bitbucket. However it doesn't mean that the repository
 * exists or is accessible. If the repository cannot be accessed most methods will fail with
 * exception.
 */
public interface Repository {
    /**
     * Uploads a file into "Downloads" tab of this repository. If the file with this name already
     * exists then it will be replaced. The provided file must exists. Uploading is done
     * asynchronously. If something goes wrong then the exception can be retrieved via returned
     * Future. There is no result if the file is uploaded successfully.
     *
     * @param file the file to upload
     * @return the future to wait for upload completion and or retrieve success/error status.
     */
    CompletableFuture<Void> addDownloadFromFile(File file);
}
