/*
 * Decompiled with CFR 0.152.
 */
package name.mlopatkin.bitbucket.api;

import name.mlopatkin.bitbucket.api.Repository;
import name.mlopatkin.bitbucket.api.RepositoryImpl;
import name.mlopatkin.bitbucket.api.RequestAuthenticator;
import name.mlopatkin.bitbucket.api.rest.RepositoryEndpoint;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;

public class Bitbucket
implements AutoCloseable {
    public static final String API_ENDPOINT = "https://api.bitbucket.org/2.0/";
    private final Retrofit mRetrofit;
    private final OkHttpClient mHttpClient;

    public Bitbucket(RequestAuthenticator authenticator) {
        this(authenticator, API_ENDPOINT);
    }

    public Bitbucket(RequestAuthenticator authenticator, String apiEndpoint) {
        this.mHttpClient = new OkHttpClient.Builder().addInterceptor(authenticator.makeInterceptor()).build();
        this.mRetrofit = new Retrofit.Builder().baseUrl(apiEndpoint).client(this.mHttpClient).build();
    }

    public Repository getRepository(String username, String repositoryName) {
        return new RepositoryImpl((RepositoryEndpoint)this.mRetrofit.create(RepositoryEndpoint.class), username, repositoryName);
    }

    @Override
    public void close() {
        this.mHttpClient.dispatcher().executorService().shutdown();
    }
}

