/*
 * Decompiled with CFR 0.152.
 */
package name.mlopatkin.bitbucket.api;

import java.io.IOException;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public abstract class RequestAuthenticator {
    public static RequestAuthenticator createForApplicationPassword(String username, String appPassword) {
        return new RequestAuthenticatorImpl(null, Credentials.basic((String)username, (String)appPassword));
    }

    public static RequestAuthenticator createForOauthToken(String token) {
        return new RequestAuthenticatorImpl("Bearer", token);
    }

    abstract Interceptor makeInterceptor();

    private static class RequestAuthenticatorImpl
    extends RequestAuthenticator
    implements Interceptor {
        private static final String AUTH_HEADER = "Authorization";
        private final String mMethod;
        private final String mCredentials;

        private RequestAuthenticatorImpl(String method, String credentials) {
            this.mMethod = method;
            this.mCredentials = credentials;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            if (request.header(AUTH_HEADER) == null) {
                request = request.newBuilder().addHeader(AUTH_HEADER, this.formatAuthHeader()).build();
            }
            return chain.proceed(request);
        }

        private String formatAuthHeader() {
            if (this.mMethod == null) {
                return this.mCredentials;
            }
            return this.mMethod + ' ' + this.mCredentials;
        }

        @Override
        Interceptor makeInterceptor() {
            return this;
        }
    }
}

