/*
 * Copyright 2021 Mikhail Lopatkin
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package name.mlopatkin.bitbucket.gradle;

import org.gradle.api.GradleException;
import org.gradle.workers.WorkAction;

import name.mlopatkin.bitbucket.api.Bitbucket;
import name.mlopatkin.bitbucket.api.Repository;
import name.mlopatkin.bitbucket.api.RequestAuthenticator;

import java.io.File;
import java.util.concurrent.ExecutionException;

import javax.inject.Inject;

abstract class UploadJob implements WorkAction<UploadJobParameters> {
    @Inject
    public UploadJob() {
    }

    @Override
    public void execute() {
        File fileToUpload = getParameters().getFileToUpload().getAsFile().get();
        String baseUrl = getParameters().getBaseUrl().get();
        String repositoryName = getParameters().getRepository().get();
        String username = getParameters().getUsername().get();
        String password = getParameters().getPassword().get();

        try (Bitbucket bitbucket = new Bitbucket(
                RequestAuthenticator.createForApplicationPassword(username, password), baseUrl)) {
            Repository repository = bitbucket.getRepository(username, repositoryName);
            try {
                repository.addDownloadFromFile(fileToUpload).get();
            } catch (InterruptedException | ExecutionException e) {
                throw new GradleException("Failed to upload file", e);
            }
        }
    }
}
