package name.pehl.piriti.client.namespaces;

import static name.pehl.piriti.client.namespaces.LotteryTicketResources.*;
import name.pehl.piriti.client.AbstractPiritiTest;

/**
 * @author $Author: harald.pehl $
 * @version $Date: 2011-03-20 21:02:59 +0100 (So, 20 Mär 2011) $ $Revision: 295
 *          $
 */
public abstract class AbstractLotteryTicketTest extends AbstractPiritiTest
{
    protected void assertLotteryTicket(LotteryTicketDns lt)
    {
        assertNotNull(lt);
        assertEquals(DATE, lt.date);
        assertNotNull(lt.player);
        assertEquals(Gender.MALE, lt.player.gender);
        assertEquals(AGE, lt.player.age);
        assertEquals(FIRSTNAME, lt.player.firstname);
        assertEquals(SURNAME, lt.player.surname);
        assertEquals(ADDRESS, lt.player.address);
        assertEquals(ADDRESS_TYPE, lt.player.addressType);
        assertTrue(lt.player.validAddress);
        assertEquals(GAME, lt.game);
        assertNotNull(lt.numbers);
        assertFalse(lt.numbers.isEmpty());
        Integer[] numbers = lt.numbers.toArray(new Integer[] {});
        assertEquals(NUMBERS.length, numbers.length);
        for (int i = 0; i < NUMBERS.length; i++)
        {
            assertEquals(NUMBERS[i], numbers[i]);
        }
    }


    protected void assertLotteryTicket(LotteryTicket lt)
    {
        assertNotNull(lt);
        assertDate(DATE, lt.date);
        assertNotNull(lt.player);
        assertEquals(Gender.MALE, lt.player.gender);
        assertEquals(AGE, lt.player.age);
        assertEquals(FIRSTNAME, lt.player.firstname);
        assertEquals(SURNAME, lt.player.surname);
        assertEquals(ADDRESS, lt.player.address);
        assertEquals(ADDRESS_TYPE, lt.player.addressType);
        assertTrue(lt.player.validAddress);
        assertEquals(GAME, lt.game);
        assertNotNull(lt.numbers);
        assertFalse(lt.numbers.isEmpty());
        Integer[] numbers = lt.numbers.toArray(new Integer[] {});
        assertEquals(NUMBERS.length, numbers.length);
        for (int i = 0; i < NUMBERS.length; i++)
        {
            assertEquals(NUMBERS[i], numbers[i]);
        }
    }
}
