/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.client.constraints;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONException;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import name.pehl.piriti.client.constraints.AbstractAmoebaTest;
import name.pehl.piriti.client.constraints.Amoeba;
import name.pehl.piriti.client.constraints.AmoebaResources;

public class JsonAmoebaReaderTest
extends AbstractAmoebaTest {
    public static final String NULL_STRING = null;
    public static final String EMPTY_STRING = "";
    public static final String BLANK_STRING = "          ";
    public static final String INVALID_JSON_STRING = "________invalid________";
    public static final String EMPTY_JSON_STRING = "{}";
    public static final JSONObject NULL_JSON_OBJECT = null;

    public void testReadSingleFromNullString() {
        Amoeba amoeba = (Amoeba)Amoeba.JSON_READER.read(NULL_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoeba);
    }

    public void testReadSingleFromEmptyString() {
        Amoeba amoeba = (Amoeba)Amoeba.JSON_READER.read(EMPTY_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoeba);
    }

    public void testReadSingleFromBlankString() {
        Amoeba amoeba = (Amoeba)Amoeba.JSON_READER.read(BLANK_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoeba);
    }

    public void testReadSingleFromInvalidString() {
        try {
            Amoeba.JSON_READER.read(INVALID_JSON_STRING);
            JsonAmoebaReaderTest.fail((String)(JSONException.class.getName() + " expected!"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void testReadSingleFromEmptyJsonString() {
        Amoeba amoeba = (Amoeba)Amoeba.JSON_READER.read(EMPTY_JSON_STRING);
        JsonAmoebaReaderTest.assertNotNull((Object)amoeba);
        JsonAmoebaReaderTest.assertEquals((Object)AmoebaResources.BLUEPRINT_AMOEBA, (Object)amoeba);
    }

    public void testReadSingleFromString() {
        String json = AmoebaResources.INSTANCE.amoebaJson().getText();
        Amoeba amoeba = (Amoeba)Amoeba.JSON_READER.read(json);
        this.assertAmoeba(amoeba, "Alpha");
    }

    public void testReadSingleFromNullJSONObject() {
        Amoeba amoeba = (Amoeba)Amoeba.JSON_READER.read(NULL_JSON_OBJECT);
        JsonAmoebaReaderTest.assertNull((Object)amoeba);
    }

    public void testReadSingleFromEmptyJSONObject() {
        Amoeba amoeba = (Amoeba)Amoeba.JSON_READER.read(new JSONObject());
        JsonAmoebaReaderTest.assertNotNull((Object)amoeba);
        JsonAmoebaReaderTest.assertEquals((Object)AmoebaResources.BLUEPRINT_AMOEBA, (Object)amoeba);
    }

    public void testReadSingleFromJSONObject() {
        JSONObject json = new JSONObject();
        json.put("name", (JSONValue)new JSONString("Alpha"));
        json.put("__size__", (JSONValue)new JSONNumber(1.0));
        Amoeba amoeba = (Amoeba)Amoeba.JSON_READER.read(json);
        this.assertAmoeba(amoeba, "Alpha");
    }

    public void testReadListFromNullString() {
        List amoebas = Amoeba.JSON_READER.readList(NULL_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromEmptyString() {
        List amoebas = Amoeba.JSON_READER.readList(EMPTY_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromBlankString() {
        List amoebas = Amoeba.JSON_READER.readList(BLANK_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromInvalidString() {
        try {
            Amoeba.JSON_READER.readList(INVALID_JSON_STRING);
            JsonAmoebaReaderTest.fail((String)(JSONException.class.getName() + " expected!"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void testReadListFromEmptyJsonString() {
        List amoebas = Amoeba.JSON_READER.readList(EMPTY_JSON_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromStringWithNonExistingArray() {
        List amoebas = null;
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": null}");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": 123}");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": true}");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": \"\"}");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": {}}");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromStringWithEmptyArray() {
        List amoebas = Amoeba.JSON_READER.readList("{\"foo\":[]}");
        JsonAmoebaReaderTest.assertNotNull((Object)amoebas);
        JsonAmoebaReaderTest.assertTrue((boolean)amoebas.isEmpty());
    }

    public void testReadListFromString() {
        String json = AmoebaResources.INSTANCE.amoebasJson().getText();
        List amoebas = Amoeba.JSON_READER.readList(json);
        this.assertAmoebas(amoebas);
    }

    public void testReadListFromNullStringWithArrayKey() {
        List amoebas = null;
        amoebas = Amoeba.JSON_READER.readList(NULL_STRING, NULL_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(NULL_STRING, EMPTY_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(NULL_STRING, BLANK_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(NULL_STRING, INVALID_JSON_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromEmptyStringWithArrayKey() {
        List amoebas = null;
        amoebas = Amoeba.JSON_READER.readList(EMPTY_STRING, NULL_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(EMPTY_STRING, EMPTY_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(EMPTY_STRING, BLANK_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(EMPTY_STRING, INVALID_JSON_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromBlankStringWithArrayKey() {
        List amoebas = null;
        amoebas = Amoeba.JSON_READER.readList(BLANK_STRING, NULL_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(BLANK_STRING, EMPTY_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(BLANK_STRING, BLANK_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(BLANK_STRING, INVALID_JSON_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromInvalidStringWithArrayKey() {
        try {
            Amoeba.JSON_READER.readList(INVALID_JSON_STRING, NULL_STRING);
            JsonAmoebaReaderTest.fail((String)(JSONException.class.getName() + " expected!"));
        }
        catch (JSONException e) {
            // empty catch block
        }
        try {
            Amoeba.JSON_READER.readList(INVALID_JSON_STRING, EMPTY_STRING);
            JsonAmoebaReaderTest.fail((String)(JSONException.class.getName() + " expected!"));
        }
        catch (JSONException e) {
            // empty catch block
        }
        try {
            Amoeba.JSON_READER.readList(INVALID_JSON_STRING, BLANK_STRING);
            JsonAmoebaReaderTest.fail((String)(JSONException.class.getName() + " expected!"));
        }
        catch (JSONException e) {
            // empty catch block
        }
        try {
            Amoeba.JSON_READER.readList(INVALID_JSON_STRING, INVALID_JSON_STRING);
            JsonAmoebaReaderTest.fail((String)(JSONException.class.getName() + " expected!"));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void testReadListFromEmptyJsonStringWithArrayKey() {
        List amoebas = null;
        amoebas = Amoeba.JSON_READER.readList(EMPTY_JSON_STRING, NULL_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(EMPTY_JSON_STRING, EMPTY_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(EMPTY_JSON_STRING, BLANK_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(EMPTY_JSON_STRING, INVALID_JSON_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromStringWithNonExistingArrayKey() {
        List amoebas = Amoeba.JSON_READER.readList("{\"foo\": []}", "bar");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromStringWithInvalidArrayKey() {
        List amoebas = null;
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": null}", "foo");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": 123}", "foo");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": true}", "foo");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": \"\"}", "foo");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList("{\"foo\": {}}", "foo");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromStringWithEmptyArrayKey() {
        List amoebas = Amoeba.JSON_READER.readList("{\"foo\": []}", "foo");
        JsonAmoebaReaderTest.assertNotNull((Object)amoebas);
        JsonAmoebaReaderTest.assertTrue((boolean)amoebas.isEmpty());
    }

    public void testReadListFromStringWithArrayKey() {
        String json = AmoebaResources.INSTANCE.amoebasJson().getText();
        List amoebas = Amoeba.JSON_READER.readList(json, "amoebas");
        this.assertAmoebas(amoebas);
    }

    public void testReadListFromNullJSONObject() {
        List amoebas = Amoeba.JSON_READER.readList(NULL_JSON_OBJECT);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromEmptyJSONObject() {
        List amoebas = Amoeba.JSON_READER.readList(new JSONObject());
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromJSONObjectWithNonExistingArray() {
        JSONObject json = null;
        List amoebas = null;
        json = new JSONObject();
        json.put("foo", (JSONValue)JSONNull.getInstance());
        amoebas = Amoeba.JSON_READER.readList(json);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        json = new JSONObject();
        json.put("foo", (JSONValue)new JSONNumber(123.0));
        amoebas = Amoeba.JSON_READER.readList(json);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        json = new JSONObject();
        json.put("foo", (JSONValue)JSONBoolean.getInstance((boolean)false));
        amoebas = Amoeba.JSON_READER.readList(json);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        json = new JSONObject();
        json.put("foo", (JSONValue)new JSONObject());
        amoebas = Amoeba.JSON_READER.readList(json);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromJSONObjectWithEmptyArray() {
        JSONObject json = new JSONObject();
        json.put("foo", (JSONValue)new JSONArray());
        List amoebas = Amoeba.JSON_READER.readList(json);
        JsonAmoebaReaderTest.assertNotNull((Object)amoebas);
        JsonAmoebaReaderTest.assertTrue((boolean)amoebas.isEmpty());
    }

    public void testReadListFromJSONObject() {
        JSONObject a = new JSONObject();
        a.put("name", (JSONValue)new JSONString("Alpha"));
        a.put("__size__", (JSONValue)new JSONNumber(1.0));
        JSONObject b = new JSONObject();
        b.put("name", (JSONValue)new JSONString("Bravo"));
        b.put("__size__", (JSONValue)new JSONNumber(1.0));
        JSONObject c = new JSONObject();
        c.put("name", (JSONValue)new JSONString("Charlie"));
        c.put("__size__", (JSONValue)new JSONNumber(1.0));
        JSONArray array = new JSONArray();
        array.set(0, (JSONValue)a);
        array.set(1, (JSONValue)b);
        array.set(2, (JSONValue)c);
        JSONObject json = new JSONObject();
        json.put("amoebas", (JSONValue)array);
        List amoebas = Amoeba.JSON_READER.readList(json);
        this.assertAmoebas(amoebas);
    }

    public void testReadListFromNullJSONObjectWithArrayKey() {
        List amoebas = null;
        amoebas = Amoeba.JSON_READER.readList(NULL_JSON_OBJECT, NULL_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(NULL_JSON_OBJECT, EMPTY_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(NULL_JSON_OBJECT, BLANK_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(NULL_JSON_OBJECT, INVALID_JSON_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromEmptyJSONObjectWithArrayKey() {
        List amoebas = null;
        amoebas = Amoeba.JSON_READER.readList(new JSONObject(), NULL_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(new JSONObject(), EMPTY_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(new JSONObject(), BLANK_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        amoebas = Amoeba.JSON_READER.readList(new JSONObject(), INVALID_JSON_STRING);
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromJSONObjectWithNonExistingArrayKey() {
        JSONObject json = new JSONObject();
        json.put("foo", (JSONValue)new JSONArray());
        List amoebas = Amoeba.JSON_READER.readList(json, "bar");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromJSONObjectWithInvalidArrayKey() {
        JSONObject json = null;
        List amoebas = null;
        json = new JSONObject();
        json.put("foo", (JSONValue)JSONNull.getInstance());
        amoebas = Amoeba.JSON_READER.readList(json, "foo");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        json = new JSONObject();
        json.put("foo", (JSONValue)new JSONNumber(123.0));
        amoebas = Amoeba.JSON_READER.readList(json, "foo");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        json = new JSONObject();
        json.put("foo", (JSONValue)JSONBoolean.getInstance((boolean)false));
        amoebas = Amoeba.JSON_READER.readList(json, "foo");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
        json = new JSONObject();
        json.put("foo", (JSONValue)new JSONObject());
        amoebas = Amoeba.JSON_READER.readList(json, "foo");
        JsonAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromJSONObjectWithEmptyArrayWithArrayKey() {
        JSONObject json = new JSONObject();
        json.put("foo", (JSONValue)new JSONArray());
        List amoebas = Amoeba.JSON_READER.readList(json, "foo");
        JsonAmoebaReaderTest.assertNotNull((Object)amoebas);
        JsonAmoebaReaderTest.assertTrue((boolean)amoebas.isEmpty());
    }

    public void testReadListFromJSONObjectWithArrayKey() {
        JSONObject a = new JSONObject();
        a.put("name", (JSONValue)new JSONString("Alpha"));
        a.put("__size__", (JSONValue)new JSONNumber(1.0));
        JSONObject b = new JSONObject();
        b.put("name", (JSONValue)new JSONString("Bravo"));
        b.put("__size__", (JSONValue)new JSONNumber(1.0));
        JSONObject c = new JSONObject();
        c.put("name", (JSONValue)new JSONString("Charlie"));
        c.put("__size__", (JSONValue)new JSONNumber(1.0));
        JSONArray array = new JSONArray();
        array.set(0, (JSONValue)a);
        array.set(1, (JSONValue)b);
        array.set(2, (JSONValue)c);
        JSONObject json = new JSONObject();
        json.put("amoebas", (JSONValue)array);
        List amoebas = Amoeba.JSON_READER.readList(json, "amoebas");
        this.assertAmoebas(amoebas);
    }

    public void testWriteNullAmoeba() {
        String json = Amoeba.JSON_WRITER.toJson(null);
        JsonAmoebaReaderTest.assertNull((Object)json);
    }

    public void testWriteEmptyAmoeba() {
        String json = Amoeba.JSON_WRITER.toJson(new Amoeba());
        JsonAmoebaReaderTest.assertEquals((String)"{\"name\":\"blueprint\",\"__size__\":0}", (String)json);
    }
}

