/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.client.constraints;

import java.util.ArrayList;
import name.pehl.piriti.client.constraints.AbstractAmoebaTest;
import name.pehl.piriti.client.constraints.Amoeba;

public class JsonAmoebaWriterTest
extends AbstractAmoebaTest {
    public static final String NULL_STRING = null;

    public void testWriteNullAmoeba() {
        String json = Amoeba.JSON_WRITER.toJson(null);
        JsonAmoebaWriterTest.assertNull((Object)json);
    }

    public void testWriteEmptyAmoeba() {
        String json = Amoeba.JSON_WRITER.toJson(new Amoeba());
        JsonAmoebaWriterTest.assertEquals((String)"{\"name\":\"blueprint\",\"__size__\":0}", (String)json);
    }

    public void testWriteAmoeba() {
        Amoeba alpha = new Amoeba();
        alpha.setName("Alpha");
        alpha.setSize(1);
        String json = Amoeba.JSON_WRITER.toJson(alpha);
        JsonAmoebaWriterTest.assertEquals((String)"{\"name\":\"Alpha\",\"__size__\":1}", (String)json);
    }

    public void testWriteAmoebaWithNullName() {
        Amoeba alpha = new Amoeba();
        alpha.setName(null);
        String json = Amoeba.JSON_WRITER.toJson(alpha);
        JsonAmoebaWriterTest.assertEquals((String)"{\"name\":null,\"__size__\":0}", (String)json);
    }

    public void testWriteNullAmoebas() {
        String json = null;
        json = Amoeba.JSON_WRITER.toJson(null, NULL_STRING);
        JsonAmoebaWriterTest.assertNull((Object)json);
        json = Amoeba.JSON_WRITER.toJson(null, "amoebas");
        JsonAmoebaWriterTest.assertNull((Object)json);
    }

    public void testWriteEmptyAmoebas() {
        String json = null;
        ArrayList amoebas = new ArrayList();
        json = Amoeba.JSON_WRITER.toJson(amoebas, NULL_STRING);
        JsonAmoebaWriterTest.assertNull((Object)json);
        json = Amoeba.JSON_WRITER.toJson(amoebas, "amoebas");
        JsonAmoebaWriterTest.assertEquals((String)"{\"amoebas\":[]}", (String)json);
    }

    public void testWriteAmoebas() {
        String json = null;
        ArrayList<Amoeba> amoebas = new ArrayList<Amoeba>();
        Amoeba a = new Amoeba();
        a.setName("Alpha");
        a.setSize(1);
        amoebas.add(a);
        Amoeba b = new Amoeba();
        b.setName("Bravo");
        b.setSize(1);
        amoebas.add(b);
        Amoeba c = new Amoeba();
        c.setName("Charlie");
        c.setSize(1);
        amoebas.add(c);
        json = Amoeba.JSON_WRITER.toJson(amoebas, NULL_STRING);
        JsonAmoebaWriterTest.assertNull((Object)json);
        json = Amoeba.JSON_WRITER.toJson(amoebas, "amoebas");
        JsonAmoebaWriterTest.assertEquals((String)"{\"amoebas\":[{\"name\":\"Alpha\",\"__size__\":1},{\"name\":\"Bravo\",\"__size__\":1},{\"name\":\"Charlie\",\"__size__\":1}]}", (String)json);
    }
}

