/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.client.constraints;

import java.util.List;
import name.pehl.piriti.client.constraints.AbstractAmoebaTest;
import name.pehl.piriti.client.constraints.Amoeba;
import name.pehl.piriti.client.constraints.AmoebaResources;
import name.pehl.totoe.xml.client.Document;
import name.pehl.totoe.xml.client.Element;
import name.pehl.totoe.xml.client.XmlParseException;
import name.pehl.totoe.xml.client.XmlParser;

public class XmlAmoebaReaderTest
extends AbstractAmoebaTest {
    public static final String NULL_STRING = null;
    public static final String EMPTY_STRING = "";
    public static final String BLANK_STRING = "          ";
    public static final String INVALID_XML_STRING = "________invalid________";
    public static final String EMPTY_SINGLE_XML_STRING = "<amoeba/>";
    public static final String EMPTY_LIST_XML_STRING = "<amoebas/>";

    public void testReadSingleFromNullString() {
        Amoeba amoeba = (Amoeba)Amoeba.XML_READER.read(NULL_STRING);
        XmlAmoebaReaderTest.assertNull((Object)amoeba);
    }

    public void testReadSingleFromEmptyString() {
        Amoeba amoeba = (Amoeba)Amoeba.XML_READER.read(EMPTY_STRING);
        XmlAmoebaReaderTest.assertNull((Object)amoeba);
    }

    public void testReadSingleFromBlankString() {
        Amoeba amoeba = (Amoeba)Amoeba.XML_READER.read(BLANK_STRING);
        XmlAmoebaReaderTest.assertNull((Object)amoeba);
    }

    public void _testReadSingleFromInvalidString() {
        try {
            Amoeba.XML_READER.read(INVALID_XML_STRING);
            XmlAmoebaReaderTest.fail((String)(XmlParseException.class.getName() + " expected!"));
        }
        catch (XmlParseException xmlParseException) {
            // empty catch block
        }
    }

    public void testReadSingleFromEmptyXmlString() {
        Amoeba amoeba = (Amoeba)Amoeba.XML_READER.read(EMPTY_SINGLE_XML_STRING);
        XmlAmoebaReaderTest.assertNotNull((Object)amoeba);
        XmlAmoebaReaderTest.assertEquals((Object)AmoebaResources.BLUEPRINT_AMOEBA, (Object)amoeba);
    }

    public void testReadSingleFromString() {
        String xml = AmoebaResources.INSTANCE.amoebaXml().getText();
        Amoeba amoeba = (Amoeba)Amoeba.XML_READER.read(xml);
        this.assertAmoeba(amoeba, "Alpha");
    }

    public void testReadSingleFromNullDocument() {
        Amoeba amoeba = (Amoeba)Amoeba.XML_READER.read(null);
        XmlAmoebaReaderTest.assertNull((Object)amoeba);
    }

    public void testReadSingleFromEmptyDocument() {
    }

    public void testReadSingleFromDocument() {
        String xml = AmoebaResources.INSTANCE.amoebaXml().getText();
        Document document = new XmlParser().parse(xml);
        Amoeba amoeba = (Amoeba)Amoeba.XML_READER.read(document);
        this.assertAmoeba(amoeba, "Alpha");
    }

    public void testReadSingleFromNullElement() {
        Amoeba amoeba = (Amoeba)Amoeba.XML_READER.read(null);
        XmlAmoebaReaderTest.assertNull((Object)amoeba);
    }

    public void testReadSingleFromEmptyElement() {
    }

    public void testReadSingleFromElement() {
        String xml = AmoebaResources.INSTANCE.amoebaXml().getText();
        Element element = new XmlParser().parse(xml).getRoot();
        Amoeba amoeba = (Amoeba)Amoeba.XML_READER.read(element);
        this.assertAmoeba(amoeba, "Alpha");
    }

    public void testReadListFromNullString() {
        List amoebas = Amoeba.XML_READER.readList(NULL_STRING);
        XmlAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromEmptyString() {
        List amoebas = Amoeba.XML_READER.readList(EMPTY_STRING);
        XmlAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromBlankString() {
        List amoebas = Amoeba.XML_READER.readList(BLANK_STRING);
        XmlAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void _testReadListFromInvalidString() {
        try {
            Amoeba.XML_READER.readList(INVALID_XML_STRING);
            XmlAmoebaReaderTest.fail((String)(XmlParseException.class.getName() + " expected!"));
        }
        catch (XmlParseException xmlParseException) {
            // empty catch block
        }
    }

    public void testReadListFromEmptyXmlString() {
        List amoebas = Amoeba.XML_READER.readList(EMPTY_LIST_XML_STRING);
        XmlAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromString() {
        String xml = AmoebaResources.INSTANCE.amoebasXml().getText();
        List amoebas = Amoeba.XML_READER.readList(xml);
        this.assertAmoebas(amoebas);
    }

    public void testReadListFromNullDocument() {
        List amoebas = Amoeba.XML_READER.readList(null);
        XmlAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromEmptyDocument() {
    }

    public void testReadListFromDocument() {
        String xml = AmoebaResources.INSTANCE.amoebasXml().getText();
        Document document = new XmlParser().parse(xml);
        List amoebas = Amoeba.XML_READER.readList(document);
        this.assertAmoebas(amoebas);
    }

    public void testReadListFromNullElement() {
        List amoebas = Amoeba.XML_READER.readList(null);
        XmlAmoebaReaderTest.assertNull((Object)amoebas);
    }

    public void testReadListFromEmptyElement() {
    }

    public void testReadListFromElement() {
        String xml = AmoebaResources.INSTANCE.amoebasXml().getText();
        Element element = new XmlParser().parse(xml).getRoot();
        List amoebas = Amoeba.XML_READER.readList(element);
        this.assertAmoebas(amoebas);
    }
}

