/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.client.constraints;

import java.util.ArrayList;
import name.pehl.piriti.client.constraints.AbstractAmoebaTest;
import name.pehl.piriti.client.constraints.Amoeba;

public class XmlAmoebaWriterTest
extends AbstractAmoebaTest {
    public static final String NULL_STRING = null;
    public static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public void testWriteNullAmoeba() {
        String xml = Amoeba.XML_WRITER.toXml(null);
        XmlAmoebaWriterTest.assertNull((Object)xml);
    }

    public void testWriteEmptyAmoeba() {
        String xml = Amoeba.XML_WRITER.toXml(new Amoeba());
        XmlAmoebaWriterTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><amoeba><name>blueprint</name><__size__>0</__size__></amoeba>", (String)xml);
    }

    public void testWriteAmoeba() {
        Amoeba alpha = new Amoeba();
        alpha.setName("Alpha");
        alpha.setSize(1);
        String xml = Amoeba.XML_WRITER.toXml(alpha);
        XmlAmoebaWriterTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><amoeba><name>Alpha</name><__size__>1</__size__></amoeba>", (String)xml);
    }

    public void testWriteAmoebaWithNullName() {
        Amoeba alpha = new Amoeba();
        alpha.setName(null);
        String xml = Amoeba.XML_WRITER.toXml(alpha);
        XmlAmoebaWriterTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><amoeba><name/><__size__>0</__size__></amoeba>", (String)xml);
    }

    public void testWriteNullAmoebas() {
        String xml = null;
        xml = Amoeba.XML_WRITER.toXml(null, NULL_STRING);
        XmlAmoebaWriterTest.assertNull((Object)xml);
        xml = Amoeba.XML_WRITER.toXml(null, "amoebas");
        XmlAmoebaWriterTest.assertNull((Object)xml);
    }

    public void testWriteEmptyAmoebas() {
        String xml = null;
        ArrayList amoebas = new ArrayList();
        xml = Amoeba.XML_WRITER.toXml(amoebas, NULL_STRING);
        XmlAmoebaWriterTest.assertNull((Object)xml);
        xml = Amoeba.XML_WRITER.toXml(amoebas, "amoebas");
        XmlAmoebaWriterTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><amoebas/>", (String)xml);
    }

    public void testWriteAmoebas() {
        String xml = null;
        ArrayList<Amoeba> amoebas = new ArrayList<Amoeba>();
        Amoeba a = new Amoeba();
        a.setName("Alpha");
        a.setSize(1);
        amoebas.add(a);
        Amoeba b = new Amoeba();
        b.setName("Bravo");
        b.setSize(1);
        amoebas.add(b);
        Amoeba c = new Amoeba();
        c.setName("Charlie");
        c.setSize(1);
        amoebas.add(c);
        xml = Amoeba.XML_WRITER.toXml(amoebas, NULL_STRING);
        XmlAmoebaWriterTest.assertNull((Object)xml);
        xml = Amoeba.XML_WRITER.toXml(amoebas, "amoebas");
        XmlAmoebaWriterTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><amoebas><amoeba><name>Alpha</name><__size__>1</__size__></amoeba><amoeba><name>Bravo</name><__size__>1</__size__></amoeba><amoeba><name>Charlie</name><__size__>1</__size__></amoeba></amoebas>", (String)xml);
    }
}

