/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.client.external;

import java.util.Date;
import java.util.List;
import name.pehl.piriti.client.AbstractPiritiTest;
import name.pehl.piriti.client.external.Customer;
import name.pehl.piriti.client.external.Order;
import name.pehl.piriti.client.external.OrderItem;
import name.pehl.piriti.client.external.Product;
import name.pehl.piriti.client.external.Shop;

public abstract class AbstractShopTest
extends AbstractPiritiTest {
    public static final Date _22_11_2010 = new Date(1290380400000L);

    protected void assertShop(Shop shop) {
        AbstractShopTest.assertNotNull((Object)shop);
        List<Customer> customers = shop.getCustomers();
        AbstractShopTest.assertNotNull(customers);
        AbstractShopTest.assertEquals((int)1, (int)customers.size());
        Customer customer = customers.iterator().next();
        this.assertGarryGourmet(customer);
        List<Product> products = shop.getProducts();
        AbstractShopTest.assertNotNull(products);
        AbstractShopTest.assertEquals((int)7, (int)products.size());
        Product product = products.get(0);
        this.assertTyhmian(product);
        Order order = shop.getOrder();
        AbstractShopTest.assertNotNull((Object)order);
        this.assertDate(_22_11_2010, order.getDate());
        customer = order.getCustomer();
        this.assertGarryGourmet(customer);
        List<OrderItem> items = order.getItems();
        AbstractShopTest.assertNotNull(items);
        AbstractShopTest.assertEquals((int)7, (int)items.size());
        OrderItem item = items.get(0);
        AbstractShopTest.assertNotNull((Object)item);
        AbstractShopTest.assertEquals((int)1, (int)item.getAmount());
        product = item.getProduct();
        this.assertTyhmian(product);
    }

    private void assertGarryGourmet(Customer customer) {
        AbstractShopTest.assertNotNull((Object)customer);
        AbstractShopTest.assertEquals((String)"gg", (String)customer.getId());
        AbstractShopTest.assertEquals((String)"Garry", (String)customer.getFirstname());
        AbstractShopTest.assertEquals((String)"Gourmet", (String)customer.getSurname());
    }

    private void assertTyhmian(Product product) {
        AbstractShopTest.assertNotNull((Object)product);
        AbstractShopTest.assertEquals((String)"tym", (String)product.getId());
        AbstractShopTest.assertEquals((String)"Tyhmian", (String)product.getName());
        AbstractShopTest.assertEquals((double)0.5, (double)product.getPrice(), (double)0.01);
        AbstractShopTest.assertTrue((boolean)product.isAvailable());
    }
}

