/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.client.external;

import java.util.List;
import name.pehl.piriti.client.external.AbstractShopTest;
import name.pehl.piriti.client.external.OrderItem;
import name.pehl.piriti.client.external.Product;
import name.pehl.piriti.client.external.Shop;
import name.pehl.piriti.client.external.ShopReader;
import name.pehl.piriti.client.external.ShopResources;

public class XmlShopTest
extends AbstractShopTest {
    public void testRead() {
        String xml = ShopResources.INSTANCE.shopXml().getText();
        Shop shop = (Shop)ShopReader.SHOP_XML_READER.read(xml);
        this.assertShop(shop);
        this.assertIdsAndReferences(shop);
    }

    private void assertIdsAndReferences(Shop shop) {
        XmlShopTest.assertSame((Object)shop.getCustomers().iterator().next(), (Object)shop.getOrder().getCustomer());
        int index = 0;
        String[] productIds = new String[]{"tym", "lft", "ons", "grl", "ros", "pts", "crt"};
        List<OrderItem> items = shop.getOrder().getItems();
        for (OrderItem item : items) {
            XmlShopTest.assertSame((Object)this.findProduct(shop, productIds[index++]), (Object)item.getProduct());
        }
    }

    private Object findProduct(Shop shop, String productId) {
        for (Product product : shop.getProducts()) {
            if (!productId.equals(product.getId())) continue;
            return product;
        }
        return null;
    }
}

