/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.client.references;

import name.pehl.piriti.client.AbstractPiritiTest;
import name.pehl.piriti.client.references.Book;
import name.pehl.piriti.client.references.BookResources;

public abstract class AbstractBookTest
extends AbstractPiritiTest {
    protected void assertBook(Book book, boolean withAuthor, boolean withRelated) {
        AbstractBookTest.assertNotNull((Object)book);
        AbstractBookTest.assertEquals((String)"978-0345417954", (String)book.isbn);
        AbstractBookTest.assertEquals((int)432, (int)book.pages);
        AbstractBookTest.assertEquals((String)"The Hotel New Hampshire", (String)book.title);
        if (withAuthor) {
            AbstractBookTest.assertEquals((String)"John", (String)book.author.firstname);
            AbstractBookTest.assertEquals((String)"Irving", (String)book.author.surname);
            this.assertBook(book.author.bestseller, false, false);
        }
        AbstractBookTest.assertEquals((int)BookResources.REVIEWS.length, (int)book.reviews.size());
        for (int index = 0; index < BookResources.REVIEWS.length; ++index) {
            AbstractBookTest.assertEquals((String)BookResources.REVIEWS[index], (String)book.reviews.get(index));
        }
        if (withRelated) {
            AbstractBookTest.assertEquals((String)"dki82", (String)book.extraInfoOfLastRelatedBook);
            AbstractBookTest.assertEquals((int)3, (int)book.related.size());
            for (Book related : book.related) {
                this.assertBook(related, true, false);
            }
        }
    }
}

