/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.client.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import name.pehl.piriti.client.AbstractPiritiTest;
import name.pehl.piriti.client.types.Amount;
import name.pehl.piriti.client.types.FatGlobalItem;
import name.pehl.piriti.client.types.FatGlobalItemResources;
import name.pehl.piriti.client.types.SkinnyNestedItem;

public abstract class AbstractFatGlobalItemTest
extends AbstractPiritiTest {
    protected Set<Integer> setOfIntegerObjectsFixture;
    protected Set<String> setOfStringsFixture;

    @Override
    protected void gwtSetUp() throws Exception {
        super.gwtSetUp();
        this.setOfIntegerObjectsFixture = new HashSet<Integer>();
        this.setOfIntegerObjectsFixture.add(0);
        this.setOfIntegerObjectsFixture.add(1);
        this.setOfIntegerObjectsFixture.add(2);
        this.setOfStringsFixture = new HashSet<String>();
        this.setOfStringsFixture.add("0");
        this.setOfStringsFixture.add("1");
        this.setOfStringsFixture.add("2");
    }

    protected void assertFatGlobalItems(Collection<FatGlobalItem> items, boolean withNestedFatGlobalItems) {
        AbstractFatGlobalItemTest.assertNotNull(items);
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)items.size());
        for (FatGlobalItem fgi : items) {
            this.assertFatGlobalItem(fgi, withNestedFatGlobalItems);
        }
    }

    protected void assertFatGlobalItem(FatGlobalItem fgi, boolean withNestedFatGlobalItems) {
        int i;
        int i2;
        AbstractFatGlobalItemTest.assertNotNull((Object)fgi);
        AbstractFatGlobalItemTest.assertTrue((boolean)fgi.booleanPrimitive);
        AbstractFatGlobalItemTest.assertTrue((boolean)fgi.booleanObject);
        AbstractFatGlobalItemTest.assertEquals((int)1, (int)fgi.bytePrimitive);
        AbstractFatGlobalItemTest.assertEquals((int)2, (int)fgi.byteObject.byteValue());
        AbstractFatGlobalItemTest.assertEquals((char)'a', (char)fgi.characterPrimitive);
        AbstractFatGlobalItemTest.assertEquals((char)'b', (char)fgi.characterObject.charValue());
        this.assertDate(FatGlobalItemResources.MY_BIRTHDAY, fgi.date);
        this.assertDate(FatGlobalItemResources.MY_SQL_BIRTHDAY, fgi.sqlDate);
        AbstractFatGlobalItemTest.assertEquals((Object)FatGlobalItemResources.TIMESTAMP, (Object)fgi.timestamp);
        AbstractFatGlobalItemTest.assertEquals((Object)FatGlobalItemResources.TIME, (Object)fgi.time);
        AbstractFatGlobalItemTest.assertEquals((Object)((Object)Amount.THREE), (Object)((Object)fgi.amount));
        AbstractFatGlobalItemTest.assertEquals((double)4.5, (double)fgi.doublePrimitive, (double)0.05);
        AbstractFatGlobalItemTest.assertEquals((double)6.7, (double)fgi.doubleObject, (double)0.05);
        AbstractFatGlobalItemTest.assertEquals((float)8.9f, (float)fgi.floatPrimitive, (float)0.05f);
        AbstractFatGlobalItemTest.assertEquals((float)10.11f, (float)fgi.floatObject.floatValue(), (float)0.05f);
        AbstractFatGlobalItemTest.assertEquals((int)12, (int)fgi.integerPrimitive);
        AbstractFatGlobalItemTest.assertEquals((int)13, (int)fgi.integerObject);
        AbstractFatGlobalItemTest.assertEquals((long)14L, (long)fgi.longPrimitive);
        AbstractFatGlobalItemTest.assertEquals((long)15L, (long)fgi.longObject);
        AbstractFatGlobalItemTest.assertEquals((int)16, (int)fgi.shortPrimitive);
        AbstractFatGlobalItemTest.assertEquals((int)17, (int)fgi.shortObject.shortValue());
        AbstractFatGlobalItemTest.assertEquals((String)"achtzehn", (String)fgi.string);
        AbstractFatGlobalItemTest.assertEquals((String)"neunzehn", (String)fgi.stringAttribute);
        if (withNestedFatGlobalItems) {
            this.assertFatGlobalItem(fgi.fatGlobalItem, false);
        }
        this.assertSkinnyNestedItem(fgi.skinnyNestedItem);
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.arrayOfIntegerPrimitives.length);
        for (i2 = 0; i2 < 3; ++i2) {
            AbstractFatGlobalItemTest.assertEquals((int)i2, (int)fgi.arrayOfIntegerPrimitives[i2]);
        }
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.arrayOfIntegerObjects.length);
        for (i2 = 0; i2 < 3; ++i2) {
            AbstractFatGlobalItemTest.assertEquals((int)i2, (int)fgi.arrayOfIntegerObjects[i2]);
        }
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.arrayOfStrings.length);
        for (i2 = 0; i2 < 3; ++i2) {
            AbstractFatGlobalItemTest.assertEquals((String)String.valueOf(i2), (String)fgi.arrayOfStrings[i2]);
        }
        if (withNestedFatGlobalItems) {
            AbstractFatGlobalItemTest.assertNotNull((Object)fgi.arrayOfFatGlobalItems);
            this.assertFatGlobalItems(Arrays.asList(fgi.arrayOfFatGlobalItems), false);
        }
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.arrayOfSkinnyNestedItems.length);
        for (i2 = 0; i2 < 3; ++i2) {
            this.assertSkinnyNestedItem(fgi.arrayOfSkinnyNestedItems[i2]);
        }
        AbstractFatGlobalItemTest.assertNull(fgi.arrayOfLists);
        AbstractFatGlobalItemTest.assertNull(fgi.arrayOfMaps);
        AbstractFatGlobalItemTest.assertNull((Object)fgi.multiDimensionalIntegerPrimitiveArray);
        AbstractFatGlobalItemTest.assertNull((Object)fgi.multiDimensionalIntegerObjectArray);
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.collectionOfIntegerObjects.size());
        fgi.collectionOfIntegerObjects.removeAll(this.setOfIntegerObjectsFixture);
        AbstractFatGlobalItemTest.assertTrue((boolean)fgi.collectionOfIntegerObjects.isEmpty());
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.collectionOfStrings.size());
        fgi.collectionOfStrings.removeAll(this.setOfStringsFixture);
        AbstractFatGlobalItemTest.assertTrue((boolean)fgi.collectionOfStrings.isEmpty());
        if (withNestedFatGlobalItems) {
            this.assertFatGlobalItems(fgi.collectionOfFatGlobalItems, false);
        }
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.collectionOfSkinnyNestedItems.size());
        for (SkinnyNestedItem sni : fgi.collectionOfSkinnyNestedItems) {
            this.assertSkinnyNestedItem(sni);
        }
        AbstractFatGlobalItemTest.assertNull((Object)fgi.untypedCollection);
        AbstractFatGlobalItemTest.assertNull(fgi.collectionOfArrays);
        AbstractFatGlobalItemTest.assertNull(fgi.collectionOfCollections);
        AbstractFatGlobalItemTest.assertNull(fgi.collectionOfMaps);
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.listOfIntegerObjects.size());
        for (i = 0; i < 3; ++i) {
            AbstractFatGlobalItemTest.assertEquals((int)i, (int)fgi.listOfIntegerObjects.get(i));
        }
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.listOfStrings.size());
        for (i = 0; i < 3; ++i) {
            AbstractFatGlobalItemTest.assertEquals((String)String.valueOf(i), (String)fgi.listOfStrings.get(i));
        }
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.arrayListOfStrings.size());
        for (i = 0; i < 3; ++i) {
            AbstractFatGlobalItemTest.assertEquals((String)String.valueOf(i), (String)fgi.arrayListOfStrings.get(i));
        }
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.linkedListOfStrings.size());
        for (i = 0; i < 3; ++i) {
            AbstractFatGlobalItemTest.assertEquals((String)String.valueOf(i), (String)fgi.linkedListOfStrings.get(i));
        }
        if (withNestedFatGlobalItems) {
            this.assertFatGlobalItems(fgi.listOfFatGlobalItems, false);
        }
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.listOfSkinnyNestedItems.size());
        for (i = 0; i < 3; ++i) {
            this.assertSkinnyNestedItem(fgi.listOfSkinnyNestedItems.get(i));
        }
        AbstractFatGlobalItemTest.assertNull((Object)fgi.untypedList);
        AbstractFatGlobalItemTest.assertNull(fgi.listOfArrays);
        AbstractFatGlobalItemTest.assertNull(fgi.listOfLists);
        AbstractFatGlobalItemTest.assertNull(fgi.listOfMaps);
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.setOfIntegerObjects.size());
        fgi.setOfIntegerObjects.removeAll(this.setOfIntegerObjectsFixture);
        AbstractFatGlobalItemTest.assertTrue((boolean)fgi.setOfIntegerObjects.isEmpty());
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.setOfStrings.size());
        fgi.setOfStrings.removeAll(this.setOfStringsFixture);
        AbstractFatGlobalItemTest.assertTrue((boolean)fgi.setOfStrings.isEmpty());
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.hashSetOfStrings.size());
        fgi.hashSetOfStrings.removeAll(this.setOfStringsFixture);
        AbstractFatGlobalItemTest.assertTrue((boolean)fgi.hashSetOfStrings.isEmpty());
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.linkedHashSetOfStrings.size());
        fgi.linkedHashSetOfStrings.removeAll(this.setOfStringsFixture);
        AbstractFatGlobalItemTest.assertTrue((boolean)fgi.linkedHashSetOfStrings.isEmpty());
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.treeSetOfStrings.size());
        fgi.treeSetOfStrings.removeAll(this.setOfStringsFixture);
        AbstractFatGlobalItemTest.assertTrue((boolean)fgi.treeSetOfStrings.isEmpty());
        if (withNestedFatGlobalItems) {
            this.assertFatGlobalItems(fgi.setOfFatGlobalItems, false);
        }
        AbstractFatGlobalItemTest.assertEquals((int)3, (int)fgi.setOfSkinnyNestedItems.size());
        for (SkinnyNestedItem sni : fgi.setOfSkinnyNestedItems) {
            this.assertSkinnyNestedItem(sni);
        }
        AbstractFatGlobalItemTest.assertNull((Object)fgi.untypedSet);
        AbstractFatGlobalItemTest.assertNull(fgi.setOfArrays);
        AbstractFatGlobalItemTest.assertNull(fgi.setOfSets);
        AbstractFatGlobalItemTest.assertNull(fgi.setOfMaps);
    }

    protected void assertSkinnyNestedItem(SkinnyNestedItem sni) {
        AbstractFatGlobalItemTest.assertNotNull((Object)sni);
        AbstractFatGlobalItemTest.assertTrue((boolean)sni.booleanPrimitive);
        AbstractFatGlobalItemTest.assertTrue((boolean)sni.booleanObject);
        AbstractFatGlobalItemTest.assertEquals((int)1, (int)sni.bytePrimitive);
        AbstractFatGlobalItemTest.assertEquals((int)2, (int)sni.byteObject.byteValue());
        AbstractFatGlobalItemTest.assertEquals((char)'a', (char)sni.characterPrimitive);
        AbstractFatGlobalItemTest.assertEquals((char)'b', (char)sni.characterObject.charValue());
        this.assertDate(FatGlobalItemResources.MY_BIRTHDAY, sni.date);
        this.assertDate(FatGlobalItemResources.MY_SQL_BIRTHDAY, sni.sqlDate);
        AbstractFatGlobalItemTest.assertEquals((Object)FatGlobalItemResources.TIMESTAMP, (Object)sni.timestamp);
        AbstractFatGlobalItemTest.assertEquals((Object)FatGlobalItemResources.TIME, (Object)sni.time);
        AbstractFatGlobalItemTest.assertEquals((Object)((Object)Amount.THREE), (Object)((Object)sni.amount));
        AbstractFatGlobalItemTest.assertEquals((double)4.5, (double)sni.doublePrimitive, (double)0.05);
        AbstractFatGlobalItemTest.assertEquals((double)6.7, (double)sni.doubleObject, (double)0.05);
        AbstractFatGlobalItemTest.assertEquals((float)8.9f, (float)sni.floatPrimitive, (float)0.05f);
        AbstractFatGlobalItemTest.assertEquals((float)10.11f, (float)sni.floatObject.floatValue(), (float)0.05f);
        AbstractFatGlobalItemTest.assertEquals((int)12, (int)sni.integerPrimitive);
        AbstractFatGlobalItemTest.assertEquals((int)13, (int)sni.integerObject);
        AbstractFatGlobalItemTest.assertEquals((long)14L, (long)sni.longPrimitive);
        AbstractFatGlobalItemTest.assertEquals((long)15L, (long)sni.longObject);
        AbstractFatGlobalItemTest.assertEquals((int)16, (int)sni.shortPrimitive);
        AbstractFatGlobalItemTest.assertEquals((int)17, (int)sni.shortObject.shortValue());
        AbstractFatGlobalItemTest.assertEquals((String)"achtzehn", (String)sni.string);
        AbstractFatGlobalItemTest.assertEquals((String)"neunzehn", (String)sni.stringAttribute);
    }
}

