/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import javax.inject.Inject;

public final class Logger {
    private final TreeLogger treeLogger;

    @Inject
    public Logger(TreeLogger treeLogger) {
        this.treeLogger = treeLogger;
    }

    public void debug(String message, Object ... params) {
        this.internalLog(TreeLogger.DEBUG, String.format(message, params));
    }

    public void info(String message, Object ... params) {
        this.internalLog(TreeLogger.INFO, String.format(message, params));
    }

    public void warn(String message, Object ... params) {
        this.internalLog(TreeLogger.WARN, String.format(message, params));
    }

    public void die(String message) throws UnableToCompleteException {
        this.internalLog(TreeLogger.ERROR, message);
        throw new UnableToCompleteException();
    }

    public void die(String message, Object ... params) throws UnableToCompleteException {
        this.internalLog(TreeLogger.ERROR, String.format(message, params));
        throw new UnableToCompleteException();
    }

    private void internalLog(TreeLogger.Type type, String message) {
        if (this.treeLogger != null) {
            this.treeLogger.log(type, message);
        } else {
            System.out.println(message);
        }
    }
}

