/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import name.pehl.piriti.rebind.Logger;
import name.pehl.piriti.rebind.RebindModule;
import name.pehl.piriti.rebind.property.PropertyContext;
import name.pehl.piriti.rebind.type.TypeContext;
import name.pehl.piriti.rebind.type.TypeProcessor;
import name.pehl.piriti.rebind.type.TypeUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public abstract class VelocityGenerator
extends Generator {
    private JClassType rwType;
    private JClassType type;

    public String generate(TreeLogger treeLogger, GeneratorContext generatorContext, String rwInterface) throws UnableToCompleteException {
        TypeOracle typeOracle = generatorContext.getTypeOracle();
        assert (typeOracle != null);
        this.validateTypes(new Logger(treeLogger), typeOracle, rwInterface);
        String implName = this.rwType.getName().replace('.', '_') + "Impl";
        String packageName = this.rwType.getPackage().getName();
        PrintWriter printWriter = generatorContext.tryCreate(treeLogger, this.rwType.getPackage().getName(), implName);
        if (printWriter != null) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new RebindModule(treeLogger, generatorContext)});
            TypeProcessor typeProcessor = (TypeProcessor)injector.getInstance(TypeProcessor.class);
            TypeContext typeContext = new TypeContext(typeOracle, this.type, this.rwType);
            List<JClassType> paramTypes = this.computeTypeChain(this.type);
            typeProcessor.process(typeContext);
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("TypeUtils", TypeUtils.class);
            velocityContext.put("typeContext", (Object)typeContext);
            velocityContext.put("implName", (Object)implName);
            velocityContext.put("paramTypes", paramTypes);
            velocityContext.put("concreteTypesMap", this.getConcreteTypes(typeOracle, typeContext));
            this.populateVelocityContext(velocityContext, typeOracle);
            VelocityEngine velocityEngine = (VelocityEngine)injector.getInstance(VelocityEngine.class);
            velocityEngine.mergeTemplate(this.getTemplateName(), "UTF-8", (Context)velocityContext, (Writer)printWriter);
            generatorContext.commit(treeLogger, printWriter);
        }
        return packageName + "." + implName;
    }

    private Map<String, Set<String>> getConcreteTypes(TypeOracle typeOracle, TypeContext typeContext) {
        HashMap<String, Set<String>> propertiesConcreteTypes = new HashMap<String, Set<String>>();
        for (PropertyContext property : typeContext.getProperties()) {
            HashSet<String> concreteTypes = new HashSet<String>();
            for (JClassType type : property.getConcreteTypes()) {
                String concreteType = TypeUtils.getReaderOrWriterImplQualifiedName(typeOracle, type, this.getInterfaceName());
                if (concreteType == null) continue;
                concreteTypes.add(concreteType);
            }
            propertiesConcreteTypes.put(property.getPathOrName(), concreteTypes);
        }
        return propertiesConcreteTypes;
    }

    private List<JClassType> computeTypeChain(JClassType type) {
        ArrayList<JClassType> typesChain = null;
        JParameterizedType parameterizedType = type.isParameterized();
        if (parameterizedType != null) {
            typesChain = new ArrayList<JClassType>();
            assert (parameterizedType.getTypeArgs().length == 1);
            this.computeTypeChain(parameterizedType.getTypeArgs()[0], typesChain);
        }
        return typesChain;
    }

    private void computeTypeChain(JClassType jClassType, List<JClassType> typesChain) {
        typesChain.add(jClassType);
        JParameterizedType parameterizedType = jClassType.isParameterized();
        if (parameterizedType != null) {
            assert (parameterizedType.getTypeArgs().length == 1);
            this.computeTypeChain(parameterizedType.getTypeArgs()[0], typesChain);
        }
    }

    protected void populateVelocityContext(VelocityContext velocityContext, TypeOracle typeOracle) {
    }

    private void validateTypes(Logger logger, TypeOracle typeOracle, String rwInterface) throws UnableToCompleteException {
        JClassType[] implementedInterfaces;
        JClassType interfaceType = typeOracle.findType(this.getInterfaceName());
        if (interfaceType == null) {
            logger.die("Unable to find metadata for type " + this.getInterfaceName());
            return;
        }
        this.rwType = typeOracle.findType(rwInterface);
        if (this.rwType == null) {
            logger.die("Unable to find metadata for type " + rwInterface);
        }
        if (interfaceType == this.rwType) {
            logger.die("You must use a subtype of %1$s in GWT.create(). E.g.,\n  interface ModelReader extends %1$s<Model> {}\n  ModelReader reader = GWT.create(ModelReader.class);", interfaceType.getSimpleSourceName());
        }
        if ((implementedInterfaces = this.rwType.getImplementedInterfaces()).length == 0) {
            logger.die("No implemented interfaces for %s", this.rwType.getSimpleSourceName());
        }
        this.type = this.findImplementedType(logger, interfaceType, implementedInterfaces);
        if (this.type == null) {
            logger.die("No type parameter found in %s", implementedInterfaces);
        }
    }

    private JClassType findImplementedType(Logger logger, JClassType interfaceType, JClassType[] implementedInterfaces) throws UnableToCompleteException {
        JClassType type = null;
        for (JClassType t : implementedInterfaces) {
            if (t.getImplementedInterfaces().length > 0 && (type = this.findImplementedType(logger, interfaceType, t.getImplementedInterfaces())) != null) break;
            if (!t.getQualifiedSourceName().equals(interfaceType.getQualifiedSourceName())) continue;
            JClassType[] typeArgs = t.isParameterized().getTypeArgs();
            if (typeArgs.length != 1) {
                logger.die("One type parameter is required for %s", t.getName());
            }
            type = typeArgs[0];
            break;
        }
        return type;
    }

    protected abstract String getInterfaceName();

    protected abstract String getTemplateName();
}

