/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.property;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import name.pehl.piriti.converter.client.BooleanConverter;
import name.pehl.piriti.converter.client.ByteConverter;
import name.pehl.piriti.converter.client.CharacterConverter;
import name.pehl.piriti.converter.client.DateConverter;
import name.pehl.piriti.converter.client.DoubleConverter;
import name.pehl.piriti.converter.client.FloatConverter;
import name.pehl.piriti.converter.client.IntegerConverter;
import name.pehl.piriti.converter.client.LongConverter;
import name.pehl.piriti.converter.client.ObjectConverter;
import name.pehl.piriti.converter.client.ShortConverter;
import name.pehl.piriti.converter.client.SqlDateConverter;
import name.pehl.piriti.converter.client.TimeConverter;
import name.pehl.piriti.converter.client.TimestampConverter;
import name.pehl.piriti.rebind.type.TypeUtils;

public class DefaultConverterLookup {
    private final TypeOracle typeOracle;
    private final Map<JClassType, String> registry;

    @Inject
    public DefaultConverterLookup(TypeOracle typeOracle) {
        this.typeOracle = typeOracle;
        this.registry = new HashMap<JClassType, String>();
        this.registry.put(typeOracle.findType(Boolean.class.getName()), BooleanConverter.class.getName());
        this.registry.put(typeOracle.findType(Byte.class.getName()), ByteConverter.class.getName());
        this.registry.put(typeOracle.findType(Character.class.getName()), CharacterConverter.class.getName());
        this.registry.put(typeOracle.findType(java.util.Date.class.getName()), DateConverter.class.getName());
        this.registry.put(typeOracle.findType(Date.class.getName()), SqlDateConverter.class.getName());
        this.registry.put(typeOracle.findType(Double.class.getName()), DoubleConverter.class.getName());
        this.registry.put(typeOracle.findType(Float.class.getName()), FloatConverter.class.getName());
        this.registry.put(typeOracle.findType(Integer.class.getName()), IntegerConverter.class.getName());
        this.registry.put(typeOracle.findType(Long.class.getName()), LongConverter.class.getName());
        this.registry.put(typeOracle.findType(Object.class.getName()), ObjectConverter.class.getName());
        this.registry.put(typeOracle.findType(Short.class.getName()), ShortConverter.class.getName());
        this.registry.put(typeOracle.findType(Time.class.getName()), TimeConverter.class.getName());
        this.registry.put(typeOracle.findType(Timestamp.class.getName()), TimestampConverter.class.getName());
    }

    public String get(JType type) {
        String converter = null;
        if (type != null) {
            if (type.isArray() != null) {
                JType componentType = type.isArray().getComponentType();
                if (componentType.isPrimitive() != null) {
                    String boxedSourceName = componentType.isPrimitive().getQualifiedBoxedSourceName();
                    JClassType boxedType = this.typeOracle.findType(boxedSourceName);
                    converter = this.registry.get(boxedType);
                } else if (componentType.isClass() != null) {
                    converter = this.registry.get(componentType.isClass());
                }
            } else if (TypeUtils.isCollection(type)) {
                JClassType typeVariable = TypeUtils.getTypeVariable(type);
                if (typeVariable != null) {
                    converter = this.registry.get(typeVariable.isClass());
                }
            } else if (TypeUtils.isMap(type)) {
                JClassType typeVariable = ((JParameterizedType)type).getTypeArgs()[0];
                if (typeVariable != null) {
                    converter = this.registry.get(typeVariable.isClass());
                }
            } else if (type.isPrimitive() != null) {
                String boxedSourceName = type.isPrimitive().getQualifiedBoxedSourceName();
                JClassType boxedType = this.typeOracle.findType(boxedSourceName);
                converter = this.registry.get(boxedType);
            } else if (type.isClass() != null) {
                converter = this.registry.get(type.isClass());
            }
        }
        return converter;
    }
}

