/*
 * Decompiled with CFR 0.152.
 */
package name.pehl.piriti.rebind.property;

import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import name.pehl.piriti.rebind.property.PropertyAccess;
import name.pehl.piriti.rebind.property.PropertySource;
import name.pehl.piriti.rebind.property.ReferenceType;
import name.pehl.piriti.rebind.property.Templates;
import name.pehl.piriti.rebind.property.Variables;
import name.pehl.piriti.rebind.type.TypeUtils;
import name.pehl.totoe.commons.client.WhitespaceHandling;
import org.apache.commons.lang.StringUtils;

public class PropertyContext {
    private static final char[] JSON_PATH_SYMBOLS = new char[]{'$', '@', '.', '[', ']', '*', '#', ',', ':', '?', '(', ')'};
    private static final char[] XPATH_SYMBOLS = new char[]{'.', '[', ']', '@', '(', ')', '/'};
    private final int order;
    private JType type;
    private JType elementType;
    private final List<JClassType> concreteTypes;
    private final String name;
    private String path;
    private String converter;
    private String format;
    private WhitespaceHandling whitespaceHandling;
    private final boolean native_;
    private String instanceCreator;
    private String getter;
    private String setter;
    private final Map<PropertyAccess, String> access;
    private final ReferenceType referenceType;
    private final Variables variables;
    private Templates templates;

    public PropertyContext(TypeOracle typeOracle, PropertySource propertySource, Map<PropertyAccess, String> access, ReferenceType referenceType) {
        this.order = propertySource.getOrder();
        JPrimitiveType primitiveType = propertySource.getType().isPrimitive();
        this.type = primitiveType != null ? typeOracle.findType(primitiveType.getQualifiedBoxedSourceName()) : propertySource.getType();
        this.concreteTypes = new ArrayList<JClassType>();
        JArrayType arrayType = this.type.isArray();
        if (arrayType != null) {
            this.elementType = arrayType.getComponentType();
            TypeUtils.collectConcreteTypes(this.concreteTypes, this.elementType);
        } else if (TypeUtils.isCollection(this.type)) {
            this.elementType = TypeUtils.getTypeVariable(this.type);
            TypeUtils.collectConcreteTypes(this.concreteTypes, this.elementType);
        } else if (TypeUtils.isMap(this.type)) {
            this.elementType = TypeUtils.getTypeVariable(this.type);
            TypeUtils.collectConcreteTypes(this.concreteTypes, this.type);
        } else {
            TypeUtils.collectConcreteTypes(this.concreteTypes, this.type);
        }
        this.name = propertySource.getName();
        if (StringUtils.isNotEmpty((String)propertySource.getPath())) {
            this.path = propertySource.getPath();
        }
        if (StringUtils.isNotEmpty((String)propertySource.getFormat())) {
            this.format = propertySource.getFormat();
        }
        this.whitespaceHandling = propertySource.getWhitespaceHandling() == null ? WhitespaceHandling.REMOVE : propertySource.getWhitespaceHandling();
        this.native_ = propertySource.isNative();
        this.access = access;
        this.referenceType = referenceType;
        this.variables = new Variables();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyContext other = (PropertyContext)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("PropertyContext [").append(this.type.getParameterizedQualifiedSourceName()).append(" ").append(this.name).append("]");
        return builder.toString();
    }

    public JType getType() {
        return this.type;
    }

    public JType getElementType() {
        return this.elementType;
    }

    public List<JClassType> getConcreteTypes() {
        return this.concreteTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getPathOrName() {
        return this.hasPath() ? this.path : this.name;
    }

    public boolean isJsonPath() {
        return StringUtils.containsAny((String)this.path, (char[])JSON_PATH_SYMBOLS);
    }

    public boolean isXpath() {
        return StringUtils.containsAny((String)this.path, (char[])XPATH_SYMBOLS);
    }

    public String getConverter() {
        return this.converter;
    }

    void setConverter(String converter) {
        this.converter = converter;
    }

    public String getFormat() {
        return this.format;
    }

    public WhitespaceHandling getWhitespaceHandling() {
        return this.whitespaceHandling;
    }

    public boolean isNative() {
        return this.native_;
    }

    public String getInstanceCreator() {
        return this.instanceCreator;
    }

    void setInstanceCreator(String instanceCreator) {
        this.instanceCreator = instanceCreator;
    }

    public String getGetter() {
        return this.getter;
    }

    void setGetter(String getter) {
        this.getter = getter;
    }

    public String getSetter() {
        return this.setter;
    }

    void setSetter(String setter) {
        this.setter = setter;
    }

    public Map<PropertyAccess, String> getAccess() {
        return this.access;
    }

    public boolean isAccessibleField() {
        return this.access.containsKey((Object)PropertyAccess.FIELD);
    }

    public boolean isCallableGetter() {
        return this.access.containsKey((Object)PropertyAccess.GETTER);
    }

    public String getCallableGetterName() {
        if (this.isCallableGetter()) {
            return this.access.get((Object)PropertyAccess.GETTER);
        }
        return null;
    }

    public boolean isCallableSetter() {
        return this.access.containsKey((Object)PropertyAccess.SETTER);
    }

    public String getCallableSetterName() {
        if (this.isCallableSetter()) {
            return this.access.get((Object)PropertyAccess.SETTER);
        }
        return null;
    }

    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public Variables getVariables() {
        return this.variables;
    }

    public Templates getTemplates() {
        return this.templates;
    }

    void setTemplates(Templates templates) {
        this.templates = templates;
    }

    public static class PropertyContextOrder
    implements Comparator<PropertyContext> {
        @Override
        public int compare(PropertyContext context1, PropertyContext context2) {
            return context1.order - context2.order;
        }
    }
}

